package com.bxm.pangu.rta.common.didi;

import com.bxm.pangu.rta.common.*;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

import java.util.List;
import java.util.function.Predicate;

/**
 * 滴滴
 *
 * @author allen
 * @date 2021-12-30
 * @since 1.0
 */
public class DidiRtaClient extends AbstractHttpClientRtaClient {

    public DidiRtaClient(DidiRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        HttpPost post = new HttpPost(getProperties().getUrl());
        post.addHeader("Content-Type", "application/x-protobuf;charset=UTF-8");
        AgencyApi.Req.Builder builder = AgencyApi.Req.newBuilder();

        String param = request.getParam();
        String[] arr = StringUtils.split(param, "|");
        if (arr.length < 2) {
            throw new RtaRequestException("param");
        }

        builder.setReqId(RandomStringUtils.randomAlphanumeric(8));
        if (StringUtils.equals(request.getOs(), RtaRequest.Os.ANDROID)) {
            builder.setPlatform(AgencyApi.OS.ANDROID);
        } else if (StringUtils.equals(request.getOs(), RtaRequest.Os.IOS)) {
            builder.setPlatform(AgencyApi.OS.IOS);
        } else {
            builder.setPlatform(AgencyApi.OS.PLATFORM_UNKNOWN);
        }

        if (StringUtils.isNotBlank(request.getIdfa())) {
            builder.setIdfa(request.getIdfa());
        }
        if (StringUtils.isNotBlank(request.getImei_md5())) {
            builder.setImeiMd5(request.getImei_md5());
        }
        if (StringUtils.isNotBlank(request.getOaid())) {
            builder.setOaid(request.getOaid());
        }
        if (StringUtils.isNotBlank(request.getOaid_md5())) {
            builder.setOaidMd5(request.getOaid_md5());
        }
        if (StringUtils.isNotBlank(request.getAndroidid_md5())) {
            builder.setAndroidIdMd5(request.getAndroidid_md5());
        }

        builder.setCaller(arr[0]);

        post.setEntity(new ByteArrayEntity(builder.build().toByteArray()));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isTarget(RtaRequest request, byte[] bytes) {
        try {
            AgencyApi.Rsp rsp = AgencyApi.Rsp.parseFrom(bytes);
            List<AgencyApi.RtaInfo> rtaInfosList = rsp.getRtaInfosList();
            return 1 == rsp.getBidType() && rtaInfosList.stream().anyMatch(new Predicate<AgencyApi.RtaInfo>() {
                @Override
                public boolean test(AgencyApi.RtaInfo rtaInfo) {
                    return StringUtils.equals(getRtaId(request.getParam()), rtaInfo.getRtaId());
                }
            });
        } catch (InvalidProtocolBufferException e) {
            throw new RtaRequestException(String.format("parseForm: %s", e.getMessage()));
        }
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Didi;
    }

    @Override
    public ProtocolFormat getProtocolFormat() {
        return ProtocolFormat.Protobuf;
    }

    private String getRtaId(String param) {
        String[] arr = StringUtils.split(param, "|");
        return arr.length >= 2 ? arr[1] : null;
    }
}
