package com.bxm.pangu.rta.common.hhdhh;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * 辉煌大航海
 *
 * @author allen
 * @date 2021-11-19
 * @since 1.0
 */
public class HhdhhRtaClient extends AbstractHttpClientRtaClient {

    private final HhdhhRtaProperties properties;

    public HhdhhRtaClient(HhdhhRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = properties.getUrl();
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();

        String pt = request.getParam();

        if (StringUtils.isNotBlank(request.getOaid())) {
            params.add("oaid", request.getOaid());
        }
        if (StringUtils.isNotBlank(request.getImei())) {
            params.add("imei", request.getImei());
        }
        if (StringUtils.isNotBlank(request.getImei_md5())) {
            params.add("imeimd5", request.getImei_md5());
        }
        if (StringUtils.isNotBlank(request.getIdfa())) {
            params.add("idfa", request.getIdfa());
        }
        if (StringUtils.isNotBlank(request.getIdfa_md5())) {
            params.add("idfamd5", request.getIdfa_md5());
        }
        if (StringUtils.isNotBlank(request.getOaid_md5())) {
            params.add("oaidmd5", request.getOaid_md5());
        }
        params.add("pt", pt);
        params.add("rta", "a");

        String finalUrl = UriComponentsBuilder.fromUriString(url).replaceQueryParams(params).build().toString();
        return new HttpGet(finalUrl);
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        return StringUtils.equals("1", json);
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Hhdhh;
    }
}
