package com.bxm.pangu.rta.common.kge;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @date 2022-03-28
 * @since 1.0
 */
@Slf4j
public class KgeRtaClient extends AbstractHttpClientRtaClient {

    public KgeRtaClient(KgeRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String url = getProperties().getUrl();
        HttpPost post = new HttpPost(url);
        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new NullPointerException("param");
        }
        String[] arr = StringUtils.split(param, "|");
        if (arr.length < 3) {
            throw new IllegalArgumentException("param");
        }
        String companySource = arr[0];
        String companyId = arr[1];
        int adId = NumberUtils.toInt(arr[2]);

        Map<String, Object> body = Maps.newHashMap();

        body.put("company_source", companySource);
        body.put("company_id", NumberUtils.toInt(companyId));
        body.put("platform", StringUtils.equals(request.getOs(), RtaRequest.Os.ANDROID) ? 1 : 2);
        body.put("idfa_md5", request.getIdfa_md5());
        body.put("imei_md5", request.getImei_md5());
        body.put("oaid_md5", request.getOaid_md5());
        body.put("android_id_md5", request.getAndroidid_md5());
        body.put("ad_ids", new int[] {adId});

        post.setEntity(new ByteArrayEntity(JsonHelper.convert2bytes(body)));

        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        if (log.isDebugEnabled()) {
            log.debug("{}", json);
        }
        return JsonHelper.convert(json, KgeResponse.class).isTarget(request);
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Kge;
    }

    @Data
    private static class KgeResponse {

        private int code = -1;
        private String msg;
        private List<String> deliver_ids;
        private List<String> filter_ids;

        public boolean isTarget(RtaRequest request) {
            if (code != 0) {
                return false;
            }
            if (CollectionUtils.isEmpty(deliver_ids)) {
                return false;
            }
            String[] arr = StringUtils.split(request.getParam(), "|");
            if (arr.length < 3) {
                throw new IllegalArgumentException("param");
            }
            return deliver_ids.stream().anyMatch(e -> StringUtils.equals(e, arr[2]));
        }
    }
}
