package com.bxm.pangu.rta.common.lazada;

import com.bxm.pangu.rta.common.RtaClientProperties;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author jingyu.li
 * @date 2023-01-06
 */
@Data
@ConfigurationProperties("rta.lazada")
public class LazadaRtaProperties implements RtaClientProperties {

    private String apiName;

    private String appKey;

    private String appSecret;

    private String urlJson;

    /**
     * 请求地址
     */
    private String url;

    private int maxTotal = 1000;

    private int defaultMaxPerRoute = 2000;

    private int connectionRequestTimeout = 500;

    private int connectTimeout = 1000;

    private int socketTimeout = 1000;

    /**
     * 是否打印异常日志
     */
    private boolean printException = false;
    /**
     * 是否开启百分位监控
     */
    private boolean publishPercentiles = false;

    private List<Long> requestTimesForWarning = Lists.newArrayList();

    @Override
    public boolean isPublishPercentiles() {
        return publishPercentiles;
    }
}
