package com.bxm.pangu.rta.common.qihang.enums;

import lombok.Getter;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
@Getter
public enum ActionTypeEnum {


    /**
     * 落地页
     */
    WEBVIEW(1, "落地页"),
    DOWNLOAD(2, "下载"),
    DP_WEBVIEW(3, "dp+webview"),
    DP_DOWNLOAD(4, "dp+download"),
    H5_DOWNLOAD(5, "h5+download"),
    ;


    private Integer code;

    private String desc;

    ActionTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static boolean isDownLoad(Integer type) {
        if (WEBVIEW.code.equals(type) || DP_WEBVIEW.code.equals(type)) {
            return false;
        }
        return true;
    }

    public static Integer toResponseActionType(Integer type, Boolean isAndroid) {
        if (WEBVIEW.code.equals(type)) {
            return 6;
        }
        if (DP_WEBVIEW.code.equals(type)) {
            return 9;
        }
        if (DP_DOWNLOAD.code.equals(type)) {
            return 11;
        }
        if (isAndroid) {
            return 2;
        }
        return 3;
    }

}
