package com.bxm.pangu.rta.common.qihang.request;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 媒体信息
 * @author allen
 */
@Data
public class App implements Serializable {
    /**
     * 媒体在流量方系统中注册后的id，也就是媒体平台的appid
     */
    private String id;
    /**
     * app名称
     */
    private String name;
    /**
     * app bundle id。Android是包名，iOS是应用商店ID。
     */
    private String bundle;
    /**
     * App version
     */
    private String ver;
    /**
     * App允许的交互类型定义
     * @see com.bxm.pangu.common.constant.bid.AppInteractionType
     */
    private List<Integer> app_interaction_type;
    /**
     * 媒体行业屏蔽标签
     * 用adxid标识行业标签来源
     */
    private List<String> excluded_product_category;

    /**
     * app分类，需配合adxid食用，比如adx是百度时，这个值由百度定义传递
     */
    private String app_category;
    
    /**
     * 用户已安装app包名
     */
    private List<String> installed_app_list;
}
