package com.bxm.pangu.rta.common.qihangForRtaApi;

import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.qihangForRtaApi.request.ExtObject;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
public class QiHangForApiRequestBuilder {

    public static com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest buildRequest(RtaRequest request) {
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Builder builder = com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.newBuilder();
        builder.setId(UUIDHelper.generate());
        builder.setApiVersion("1.0.0");
        builder.setTest(1);
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Device device = buildDevice(request);
        if (device != null) {
            builder.setDevice(device);
        }
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.App app = buildApp(request);
        if (app != null) {
            builder.setApp(app);
        }

        List<com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Imp> imps = Lists.newArrayList();
        imps.add(buildImp(request));
        builder.addAllImp(imps);
        builder.setSspTime(System.currentTimeMillis());
        return builder.build();
    }

    public static com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Device buildDevice(RtaRequest request) {
        if (request == null) {
            return null;
        }
        return com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Device.newBuilder()
                .setUa("")
                .setIp("")
                .setDeviceType(0)
                .setMake("")
                .setModel("")
                .setIdfa(getValueOrEmpty(request.getIdfa()))
                .setIdfaMd5(getValueOrEmpty(request.getIdfa_md5()))
                .setOaid(getValueOrEmpty(request.getOaid()))
                .setOaidMd5(getValueOrEmpty(request.getOaid_md5()))
                .setImei(getValueOrEmpty(request.getImei()))
                .setImeiMd5(getValueOrEmpty(request.getImei_md5()))
                .setOs(StringUtils.isNotBlank(request.getOs()) ? request.getOs() : "android")
                .setOsv("")
                .setCarrier(0)
                .setConnectionType(0)
                .setAndroidId(getValueOrEmpty(request.getAndroidid()))
                .setAndroidIdMd5(getValueOrEmpty(request.getAndroidid_md5()))
                .setMac("")
                .setMacMd5("")
                .build();

    }

    private static String getValueOrEmpty(String data) {
        return data == null ? "" : data;
    }

    public static com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Imp buildImp(RtaRequest request) {
        String param = request.getParam();
        ExtObject convert = StringUtils.isBlank(param) ? new ExtObject() : JsonHelper.convert(param, ExtObject.class);
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Imp.Builder builder = com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Imp.newBuilder();
        builder.setId(UUIDHelper.generate());
        builder.setTagId(StringUtils.isNotBlank(convert.getTagId()) ? convert.getTagId() : "bxm_9_1_gd");
        builder.setSubTagId(StringUtils.isNotBlank(convert.getTagId()) ? convert.getTagId() : "bxm_9_1_gd");
        builder.setAdType(convert.getAdType() != null ? convert.getAdType() : 2);
        builder.setBidType(convert.getBidType() != null ? convert.getBidType() : 0);
        builder.setBidFloor(convert.getBidFloor() != null ? convert.getBidFloor() : 0);
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Imp.Asset.Builder assetBuilder = com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.Imp.Asset.newBuilder();
        assetBuilder.setTemplateId(StringUtils.isNotBlank(convert.getTemplateId()) ? convert.getTemplateId() : "bxm_kp_5");
        assetBuilder.setHeight(convert.getHeight() != null ? convert.getHeight() : 1280);
        assetBuilder.setWidth(convert.getWidth() != null ? convert.getWidth() : 720);
        builder.addAsset(assetBuilder);
        return builder.build();
    }

    public static com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.App buildApp(RtaRequest request) {
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest.App.Builder builder = SurgeBidding.BidRequest.App.newBuilder();
        builder.setBundle(StringUtils.isNotBlank(request.getExt()) ? request.getExt() : "com.kuaishou.nebula");
        return builder.build();
    }

}
