package com.bxm.pangu.rta.common.qihangForRtaApi.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 广告位信息
 * @author allen
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class PanGuImpression implements Serializable {

    /**
     * 广告位ID
     */
    private String tag_id;
    /**
     * 广告位场景类型
     * @see PositionType
     */
    private Integer type;
    /**
     * 底价，单位：厘
     */
    private BigDecimal bid_floor;
    /**
     * 广告位高
     */
    private Integer h;
    /**
     * 广告位宽
     */
    private Integer w;
    /**
     * imp id
     */
    private String id;
    /**
     * 外部广告位ID
     */
    private String ext_tag_id;
}
