package com.bxm.pangu.rta.common.taobao;

import com.bxm.pangu.rta.common.RtaClientProperties;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * @author allen
 * @date 2021-10-13
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "rta.taobao")
public class TaobaoRtaProperties implements RtaClientProperties {

    private String url = "http://gw.api.taobao.com/router/rest";
    private String appKey = "29155280";
    private String appSecret = "9bfe42052536d52723fff94c8c76cf4a";
    private String channel = "2200803434155";
    private String advertisingSpaceId= "447574";
    private int connectTimeout = 50;
    private int socketTimeout = 60;

    /**
     * Taobao SDK 是否需要开启日志。默认：false
     */
    private boolean needEnableLogger = false;
    /**
     * 是否开启百分位监控
     */
    private boolean publishPercentiles = false;

    public Function<Map<Object, Object>, Boolean> targetHandler;

    private List<Long> requestTimesForWarning = Lists.newArrayList();

    @Override
    public boolean isPublishPercentiles() {
        return this.publishPercentiles;
    }

    @Override
    public String toSimpleString() {
        return "TaobaoRtaProperties{" +
                "url='" + url + '\'' +
                ", appKey='" + appKey + '\'' +
                ", appSecret='" + appSecret + '\'' +
                ", channel='" + channel + '\'' +
                ", advertisingSpaceId='" + advertisingSpaceId + '\'' +
                ", connectTimeout=" + connectTimeout +
                ", socketTimeout=" + socketTimeout +
                '}';
    }
}
