package com.bxm.pangu.rta.common.taobao_vegas;

import com.bxm.pangu.rta.common.RtaClientProperties;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * @author allen
 * @date 2021-10-13
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "rta.taobao-vegas")
public class TaobaoVegasRtaProperties implements RtaClientProperties {

    private String url = "http://gw.api.taobao.com/router/rest";
    private int connectTimeout = 50;
    private int socketTimeout = 60;

    /**
     * Taobao SDK 是否需要开启日志。默认：false
     */
    private boolean needEnableLogger = false;

    @Override
    public List<Long> getRequestTimesForWarning() {
        return Lists.newArrayList();
    }
}
