package com.bxm.pangu.rta.common.testing;

import com.bxm.pangu.rta.common.*;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

/**
 * @author allen
 * @date 2022-02-16
 * @since 1.0
 */
public class TestingRtaClient implements RtaClient {

    private final TestingRtaProperties properties;

    public TestingRtaClient(TestingRtaProperties properties) {
        this.properties = properties;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Testing;
    }

    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        String id = StringUtils.isNotBlank(request.getImei_md5()) ? request.getImei_md5()
                : StringUtils.isNotBlank(request.getOaid_md5()) ? request.getOaid_md5()
                : StringUtils.isNotBlank(request.getIdfa_md5()) ? request.getIdfa_md5()
                : null;
        if (StringUtils.isBlank(id)) {
            return false;
        }
        boolean isTarget = NumberUtils.isNumber(StringUtils.substring(id, id.length() - 1));
        if (isTarget && Objects.nonNull(feedback)) {
            feedback.accept(Maps.newHashMap());
        }
        return isTarget;
    }

    @Override
    public RtaClientProperties getProperties() {
        return properties;
    }
}
