package com.bxm.pangu.rta.common.uc;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

/**
 * @author tangx
 * @date 2022/6/17 15:35
 */
@Slf4j
public class UcRtaClient extends AbstractHttpClientRtaClient {

    public UcRtaClient(UcRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = Optional.ofNullable(request.getParam()).orElse("quwei|uclink_ac16cc");
        String[] split = StringUtils.split(param, "|");
        if (split.length != 2) {
            throw new IllegalArgumentException("param");
        }
        String code =  split[0];
        String pd = split[1];

        String url = getProperties().getUrl();
        url = StringUtils.replace(url, "<code>", code)
                .replace("<pd>", pd);

        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", MediaType.APPLICATION_JSON_UTF8_VALUE);
        UcParam.UcParamBuilder builder = UcParam.builder();

        // 文档说明：设备信息尽量传入原值，如只能获取md5值也传入相应的参数
        if (StringUtils.equals(request.getOs(), RtaRequest.Os.ANDROID)) {
            builder.os(UcParam.OS_ANDROID);
            if (StringUtils.isNotBlank(request.getOaid())) {
                builder.oaid(request.getOaid());
            } else {
                builder.oaid(request.getOaid_md5());
            }
            if (StringUtils.isNotBlank(request.getImei())) {
                builder.did(request.getImei());
            } else {
                builder.did(request.getImei_md5());
            }
            if (StringUtils.isNotBlank(request.getAndroidid())) {
                builder.dpid(request.getAndroidid());
            } else {
                builder.dpid(request.getAndroidid_md5());
            }
        } else if (StringUtils.equals(request.getOs(), RtaRequest.Os.IOS)) {
            builder.os(UcParam.OS_IOS);
            if (StringUtils.isNotBlank(request.getIdfa())) {
                builder.idfa(request.getIdfa());
            } else {
                builder.idfa(request.getIdfa_md5());
            }
        }

        post.setEntity(new StringEntity(JsonHelper.convert(builder.build()), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        // 1.命中 0.未命中 2.错误
        return Objects.equals(json, "1");
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Uc;
    }


}
