package com.bxm.pangu.rta.common.xinyi;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.AbstractRtaProperties;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.baichuan.BaichuanResponse;
import com.bxm.pangu.rta.common.uc.UcParam;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.springframework.http.MediaType;

import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * @author tangx
 * @date 2022/8/25 15:35
 */
@Slf4j
public class XinyiRtaClient extends AbstractHttpClientRtaClient {

    public XinyiRtaClient(XinyiRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = Optional.ofNullable(request.getParam()).orElse("");
        String[] split = StringUtils.split(param, "|");
        if (split.length != 2) {
            throw new IllegalArgumentException("param");
        }

        String token =  split[0];
        String tasks = split[1];

        List<String> taskList = Arrays.asList(tasks.split(","));
        if (CollectionUtils.isEmpty(taskList)) {
            throw new IllegalArgumentException("xinyi tasks cannot be empty");
        }

        String url = getProperties().getUrl();
        url = StringUtils.replace(url, "{token}", token);

        String type = "";
        String id = "";
        if (StringUtils.equals(request.getOs(), RtaRequest.Os.ANDROID)) {
            if (StringUtils.isNotBlank(request.getOaid())) {
                type = "oaid";
                id = request.getOaid();
            } else if (StringUtils.isNotBlank(request.getOaid_md5())){
                type = "oaid_md5";
                id = request.getOaid_md5();
            } else if (StringUtils.isNotBlank(request.getImei())) {
                type = "imei";
                id = request.getImei();
            } else if (StringUtils.isNotBlank(request.getImei_md5())) {
                type = "imei_md5";
                id = request.getImei_md5();
            }
        } else if (StringUtils.equals(request.getOs(), RtaRequest.Os.IOS)) {
            if (StringUtils.isNotBlank(request.getIdfa())) {
                type = "idfa";
                id = request.getIdfa();
            } else if (StringUtils.isNotBlank(request.getIdfa_md5())) {
                type = "idfa_md5";
                id = request.getIdfa_md5();
            }
        }

        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", MediaType.APPLICATION_JSON_UTF8_VALUE);
        Map<String, Object> paramMap = new HashMap<>();

        paramMap.put("type", type);
        paramMap.put("id", id);
        paramMap.put("tasks", taskList);

        post.setEntity(new StringEntity(JsonHelper.convert(paramMap), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        // 配置的taskId 与返回结果的taskId有交集即成功
        XinyiResponse xinyiResponse = JsonHelper.convert(json, XinyiResponse.class);
        List<String> responseTasks = xinyiResponse.getTasks();
        if (CollectionUtils.isNotEmpty(responseTasks)) {
            String param = request.getParam();
            String[] split = StringUtils.split(param, "|");
            if (split.length == 2) {
                String tasks = split[1];
                List<String> taskList = Lists.newArrayList();
                taskList.addAll(Arrays.asList(tasks.split(",")));
                taskList.retainAll(responseTasks);
                if (CollectionUtils.isNotEmpty(taskList)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Xinyi;
    }

    @Data
    private static class XinyiResponse {
        private List<String> tasks;
    }
}
