package com.bxm.pangu.rta.common;

/**
 * RTA 类型
 *
 * @author allen
 * @date 2021-12-20
 * @since 1.0.0
 */
public enum RtaType {

    /**
     * For testing
     */
    Testing(0),

    /**
     * 淘宝
     */
    Taobao(1),

    /**
     * 快手
     */
    KuaiShou(2),

    /**
     * OneWay Agency
     */
    OneWay(3),

    /**
     * 麦晗
     */
    Myhayo(4),

    /**
     * 百度
     */
    Baidu(5),

    /**
     * 辉煌大航海
     */
    Hhdhh(6),

    /**
     * 西安鲸鱼
     */
    XiAnJingYu(7),

    /**
     * 个推
     */
    Getui(8),

    /**
     * 芒果联盟
     */
    Mango(9),

    /**
     * 腾讯视频
     */
    TencentVideo(10),

    /**
     * 滴滴
     */
    Didi(11),

    /**
     * 瑞狮网络
     */
    Vlion(12),

    /**
     * 硬核创世
     */
    Yhcs(13),

    /**
     * 知乎
     */
    Zhihu(14),

    /**
     * 百川
     */
    Baichuan(15),

    /**
     * 美团
     */
    Meituan(16),

    /**
     * 百度沉默
     */
    BaiduSilent(17),

    /**
     * 全民K歌
     */
    Kge(18),

    /**
     * 斗鱼
     */
    Douyu(19),

    /**
     * 淘宝活动
     */
    TaobaoActivity(20),

    /**
     * 汽车之家
     */
    Autohome(21),

    /**
     * uc
     */
    Uc(22),

    /**
     * 天眼查
     */
    TianYanCha(23),

    /**
     * 京东（金融）
     */
    Jd(24),

    /**
     * 高德
     */
    Amap(25),

    /**
     * 新义
     */
    Xinyi(26),

    /**
     * 个推天眼查
     */
    Gttyc(27),

    /**
     * 极光天猫
     */
    Tmall(28),

    /**
     * 淘宝客-推广者-红包领取状态查询
     * https://open.taobao.com/api.htm?docId=52958&docType=2&source=search
     */
    TaobaoVegas(29),

    /**
     * 唱吧
     */
    ChangBa(30),

    /**
     * lazada
     */
    Lazada(31),

    /**
     * 粉象-抖音
     */
    dyfx(32),

    /**
     * 第三方电商会员模型
     */
    dsfds(33),

    /**
     * 淘宝福利购
     * https://www.teambition.com/task/64f835b471364563705493da
     */
    Tbflg(34),

    /**
     * 汽车之家RTA
     * https://www.teambition.com/task/64f835b471364563705493da
     */
    Qczj(35),

    /**
     * 快手RTA
     * https://www.teambition.com/task/652e593ee5d3e08a599ee852
     */
    Kwai(36),

    /**
     * uc RTA https://www.teambition.com/task/657a9d0158fa39fec1950a01
     */
    Ucgf(37),

    /**
     * 启航rtb https://www.teambition.com/task/65eea12116a8187a23b2f441
     */
    QiHangRtb(38),

    /**
     * 抖音电商 https://www.teambition.com/task/65fa3fe265e98921119450f1
     */
    Dyds(39),

    /**
     * 启航rtb https://www.teambition.com/task/65eea12116a8187a23b2f441
     */
    QiHangRtbForApi(40),

    /**
     * 暴走鱼 https://www.teambition.com/task/66271106f1479e14dd6049ce
     */
    Bzy(41),
    ;

    private final int type;

    RtaType(int type) {
        this.type = type;
    }

    public static RtaType of(int type) {
        for (RtaType value : values()) {
            if (type == value.getType()) {
                return value;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }
}
