package com.bxm.pangu.rta.common.qihang.request;

import com.bxm.warcar.utils.Constants;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * 竞价请求
 *
 * @author allen
 * @date 2021-06-09
 * @since 1.0
 */
@Data
public class BidRequest implements Serializable {

    /**
     * 流量方标志
     */
    private Integer adxid;
    /**
     * BidId
     */
    private String bidid;
    /**
     * 媒体信息
     */
    private App app;
    /**
     * 广告位信息
     */
    private PanGuImpression imp;
    /**
     * 受众设备信息
     */
    private PanGuDevice device;
    /**
     * 地理位置信息
     */
    private Geo geo;
    /**
     * 拍卖类型
     */
    private Integer bidding_type;
    /**
     * 竞价类型
     */
    private Integer at;
    /**
     * 扩展属性
     */
    private String ext;
    /**
     * 是否测试流量
     */
    private Integer test;
    /**
     * 竞价模式
     */
    private Short bid_model = BidModel.SINGLE_CPM;

    private Runtime runtime;
    /**
     * 本次请求是否是测试
     * @return 是、否
     */
    public boolean isTest() {
        return Objects.equals(test, Constants.YES);
    }

    public Runtime getRuntime() {
        if (Objects.isNull(runtime)) {
            this.runtime = new Runtime();
        }
        return runtime;
    }
}
