package com.bxm.pangu.rta.common.qihangForRtaApi.enums;

import lombok.Getter;

/**
 * @author zhangdong
 * @date 2022/10/13
 */
@Getter
public enum CarrierEnum {

    /**
     * 未知
     */
    UNKNOWN(0, "未知"),

    /**
     * 移动
     */
    MOBILE(1, "移动"),
    /**
     * 联通
     */
    UNICOM(2, "联通"),
    /**
     * 电信
     */
    TELECOM(3, "电信");

    private Integer code;

    private String desc;

    CarrierEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer toRequestCarrier(Integer type) {
        AdxConstants.Carrier carrier = AdxConstants.Carrier.getCarrier(type);
        switch (carrier) {
            case TELECOM:
                return TELECOM.code;
            case MOBILE:
                return MOBILE.code;
            case UNICOM:
                return UNICOM.code;
            default:
                return UNKNOWN.code;
        }
    }

    public static Integer toRequestCarrier(Long type) {
        if (type == 46003L) {
            return TELECOM.code;
        } else if (type == 46000L) {
            return MOBILE.code;
        } else if (type == 46001L) {
            return UNICOM.code;
        }
        return UNKNOWN.code;
    }
}
