package com.bxm.pangu.rta.common.qihangForRtaApi.request;

import com.google.common.collect.Maps;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 运行时对象。
 *
 * @author allen
 * @date 2021-10-18
 * @since 1.0
 * @see com.bxm.pangu.common.constant.Constants.RuntimeAttach
 */
@Data
public class Runtime implements Serializable {

    private static final long serialVersionUID = -73722795567461529L;

    /**
     * 自定义附件内容。
     */
    private Map<Object, Object> attach = Maps.newHashMap();

    /**
     * 存储一个对象。
     * @param k Key。强烈建议在 {@link com.bxm.pangu.common.constant.Constants.RuntimeAttach} 中定义常量，便于维护。
     * @param v Value
     * @return 与key关联的先前值，如果没有key 的映射，则为null 。 （如果实现支持null值，则返回null还可以指示映射先前将null与key关联。）
     */
    public Object put(Object k, Object v) {
        return attach.put(k, v);
    }

    public Object get(Object k) {
        return attach.get(k);
    }
}
