package com.bxm.pangu.rta.common.the_aurora_tmall;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.*;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.springframework.http.MediaType;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author jingyu.li
 * @date 2022-10-09
 */
public class TheAuroraTmallClient extends AbstractHttpClientRtaClient {

    private static final String OAID = "545";
    private static final String IMEI = "546";
    private static final String IDFA = "547";
    private static final String UN_MD5 = "0";
    private static final String MD5 = "1";
    private static final String ANDROID = "Android";
    private static final String IOS = "iOS";

    private final TheAuroraTmallRtaProperties properties;

    public TheAuroraTmallClient(TheAuroraTmallRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    /**
     * 每次RTA请求来的时候，先判断os，如果是安卓，优先oaid，如果没有，取IMEI
     * 如果是ios，就取IDFA
     * 两个操作系统，优先取原值，没有取MD5
     */
    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new RtaRequestException("The param cannot be empty");
        }

        String appId = null;
        List<String> devices = null;
        String encryption = UN_MD5;
        if (RtaRequest.Os.ANDROID.equals(request.getOs())) {
            appId = OAID;
            if (StringUtils.isNotBlank(request.getOaid())) {
                devices = Lists.newArrayList(request.getOaid());
            } else if (StringUtils.isNotBlank(request.getOaid_md5())) {
                devices = Lists.newArrayList(request.getOaid_md5());
                encryption = MD5;
            }
            if (CollectionUtils.isEmpty(devices)) {
                appId = IMEI;
                if (StringUtils.isNotBlank(request.getImei())) {
                    devices = Lists.newArrayList(request.getImei());
                } else if (StringUtils.isNotBlank(request.getImei_md5())) {
                    devices = Lists.newArrayList(request.getImei_md5());
                    encryption = MD5;
                }
            }
        } else {
            appId = IDFA;
            if (StringUtils.isNotBlank(request.getIdfa())) {
                devices = Lists.newArrayList(request.getIdfa());
            } else if (StringUtils.isNotBlank(request.getIdfa_md5())) {
                devices = Lists.newArrayList(request.getIdfa_md5());
                encryption = MD5;
            }
        }

        String os_type = ANDROID;
        if (RtaRequest.Os.IOS.equals(request.getOs())) {
            os_type = IOS;
        }

        String[] arr = StringUtils.splitPreserveAllTokens(param, "|");
        if (arr.length < 2) {
            throw new RtaRequestException("param must be {api_key}|{api_secret}");
        }
        String authorization = null;
        try {
            authorization = Base64.getEncoder().encodeToString((arr[0] + ":" + arr[1]).getBytes("utf-8"));
        } catch (UnsupportedEncodingException e) {
            throw new RtaRequestException("authorization convert exceptions");
        }

        HttpPost post = new HttpPost(getProperties().getUrl());
        post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE);
        post.addHeader("authorization", "Basic " + authorization);

        Map<String, Object> map = new HashMap<>();
        map.put("app_id",appId);
        map.put("os_type",os_type);
        map.put("devices",devices);
        //0:不加密，1:原文MD5，2:原文小写MD5，3:原文大写MD5
        map.put("encryption",encryption);
        //投放媒体的包名，非必填填
//        map.put("media_app","");
        post.setEntity(new ByteArrayEntity(JsonHelper.convert2bytes(map)));

        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        JSONObject response = JSONObject.parseObject(json);
        if (response.getInteger("code") != 0) {
            return false;
        }
        if (response.getJSONObject("data").getJSONArray("device").isEmpty()) {
            return false;
        }

        return true;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Tmall;
    }
}
