package com.bxm.pangu.rta.common;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Objects;

/**
 * @author allen
 * @date 2021-12-20
 * @since 1.0
 */
@Data
@Accessors(chain = true)
public class RtaRequest {

    /**
     * 自定义参数配置，请根据不同 RTA 类型来约定。
     */
    private String param;

    /**
     * 操作系统
     * @see Os
     */
    private String os;

    /**
     * imei
     */
    private String imei;
    private String imei_md5;
    /**
     * idfa
     */
    private String idfa;
    private String idfa_md5;
    /**
     * AndroidId
     */
    private String androidid;
    private String androidid_md5;
    /**
     * OAID
     */
    private String oaid;
    private String oaid_md5;
    /**
     * Google Advertising ID,谷歌广告标识码
     */
    private String gaid;
    private String gaid_md5;
    /**
     * CAID
     */
    private List<Caid> caid_info;

    /**
     * 国家代码 如：CN
     */
    private String countryCode;

    /**
     * 根据媒体不同用这个字段区分特殊返回类型
     */
    private String type;

    /**
     * 自定义扩展参数
     */
    private String ext;

    @Data
    @Accessors(chain = true)
    public static class Caid {
        /**
         * 当前caid值，当获取不到idfa 的情况下， 需要传递该ID信息或 者生成caid的参数信息
         */
        private String caid;
        /**
         * 当前 caid 版本号， CAID 接口返回的当前版本号
         */
        private String caid_version;
        /**
         * 加密方式 1/明文，2/MD5
         */
        private Integer en_type;

        public boolean isMd5() {
            return Objects.equals(en_type, 2);
        }
    }

    public interface Os {

        // 请使用小写来定义 //

        /**
         * Android
         */
        String ANDROID = "android";

        /**
         * iOS
         */
        String IOS = "ios";

        /**
         * 鸿蒙
         */
        String HARMONY = "harmony";

        /**
         * Web
         */
        String WEB = "web";

        /**
         * 其他
         */
        String OTHER = "other";
    }
}
