package com.bxm.pangu.rta.common.core;

import com.bxm.pangu.rta.common.RtaClient;
import com.bxm.pangu.rta.common.RtaRequest;

import java.util.EventObject;

/**
 * 实际到达 RTA 服务商的请求事件。
 *
 * @author allen
 * @date 2022-02-22
 * @since 1.0
 */
public class RequestEvent extends EventObject {

    private final RtaClient rtaClient;
    private final RtaRequest rtaRequest;
    private final boolean target;

    public RequestEvent(Object source, RtaClient rtaClient, RtaRequest rtaRequest, boolean target) {
        super(source);
        this.rtaClient = rtaClient;
        this.rtaRequest = rtaRequest;
        this.target = target;
    }

    public RtaClient getRtaClient() {
        return rtaClient;
    }

    public RtaRequest getRtaRequest() {
        return rtaRequest;
    }

    public boolean isTarget() {
        return target;
    }
}
