package com.bxm.pangu.rta.common.dsfds;

import com.alibaba.fastjson.JSONObject;
import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaRequestException;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.springframework.http.MediaType;

import java.util.ArrayList;

/**
 * 第三方电商会员模型
 * @author jingyu.li
 * @date 2023-04-11
 */
public class DsfdsRtaClient extends AbstractHttpClientRtaClient {

    private final DsfdsRtaProperties properties;

    public DsfdsRtaClient(DsfdsRtaProperties properties) {
        super(properties);
        this.properties = properties;
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = request.getParam();
        if (StringUtils.isBlank(param)) {
            throw new RtaRequestException("The parameter format is 'id'");
        }

        DsfdsRtaRequest dsfdsRtaRequest = new DsfdsRtaRequest();
        dsfdsRtaRequest.setId(param);
        dsfdsRtaRequest.setChannel(properties.getChannel());

        ArrayList<String> dmIds = new ArrayList<>();
        String imeiMd5 = request.getImei_md5();
        if (StringUtils.isNotBlank(imeiMd5)) {
            dmIds.add("D10");
            dsfdsRtaRequest.setDm_ids(dmIds);
            dsfdsRtaRequest.setDevice_type(3);
            dsfdsRtaRequest.setDevice_num(imeiMd5);
        }

        String oaidMd5 = request.getOaid_md5();
        if (StringUtils.isBlank(dsfdsRtaRequest.getDevice_num()) && StringUtils.isNotBlank(oaidMd5)) {
            dmIds.add("D11");
            dsfdsRtaRequest.setDm_ids(dmIds);
            dsfdsRtaRequest.setDevice_type(5);
            dsfdsRtaRequest.setDevice_num(oaidMd5);
        }

        if (StringUtils.isBlank(dsfdsRtaRequest.getDevice_num())) {
            throw new RtaRequestException("deviceNum is empty");
        }

        HttpPost httpPost = new HttpPost(properties.getUrl());
        httpPost.addHeader("Content-Type", MediaType.APPLICATION_JSON_UTF8_VALUE);
        httpPost.setEntity(new ByteArrayEntity(JsonHelper.convert2bytes(dsfdsRtaRequest)));

        return httpPost;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        JSONObject response = JSONObject.parseObject(json);
        int code = (int)response.get("code");
        if (code != 0) {
            return false;
        }
        JSONObject dms = response.getJSONObject("dms");
        if (dms == null) {
            return false;
        }

        Integer d10 = dms.getInteger("D10");
        Integer d11 = dms.getInteger("D11");
        if ((d10 == null || d10 != 0) && (d11 == null || d11 != 0)) {
            return false;
        }

        return true;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.dsfds;
    }
}
