package com.bxm.pangu.rta.common.jdjr;

import com.jddglobal.open.request.base.JddRequest;
import com.jddglobal.open.support.util.JacksonUtils;
import org.apache.http.client.utils.DateUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 从京东demo直接复制过来的
 * @author lijingyu
 * @since 2023-03-22
 */
public class MarketShowAdBatchRequest implements JddRequest<MarketShowAdBatchResponse> {

    /**
     * 渠道编码/媒体编码
     */
    private String channelCode;

    /**
     * fid
     */
    private String fid;

    /**
     * 设备ID列表
     * 为了接口性能考虑，一次最多处理10条设备id
     * map的key idType   设备ID类型  imei、oaid、idfa 等
     * map的key idMd5Value 设备ID明文先转大写，然后再md5计算的值
     */
    private List<Map<String, String>> deviceIds;

    public String getApiMethod() {
        return "/smapi/v1/market/showAdBatch";
    }

    public String getJsonParams() {
        return JacksonUtils.toJson(this);
    }

    public Class getResponseClass() {
        return MarketShowAdBatchResponse.class;
    }

    public String getRequestTime() {
        return DateUtils.formatDate(new Date(), "yyyyMMddHHmmssSSS");
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getFid() {
        return fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public List<Map<String, String>> getDeviceIds() {
        return deviceIds;
    }

    public void setDeviceIds(List<Map<String, String>> deviceIds) {
        this.deviceIds = deviceIds;
    }
}
