package com.bxm.pangu.rta.common.qihangForRtaApi;

import com.bxm.pangu.rta.common.*;
import com.bxm.pangu.rta.common.qihang.proto.SurgeBidding;
import com.bxm.pangu.rta.common.utils.HttpClientUtils;
import com.bxm.warcar.utils.DateHelper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @author jingyu.li
 * @date 2024-03-11
 */
@Slf4j
@EnableConfigurationProperties({QiHangRtaForApiClient.class})
public class QiHangRtaForApiClient implements RtaClient {

    private final QiHangRtaForApiProperties properties;
    private final HttpClient httpClient;

    public QiHangRtaForApiClient(QiHangRtaForApiProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientUtils.createHttpClient(properties.getMaxTotal(), properties.getDefaultMaxPerRoute(),
                properties.getConnectionRequestTimeout(), properties.getConnectTimeout(), properties.getSocketTimeout());
    }

    /**
     * 盘古调这个方法
     * @param request 请求对象
     * @param feedback 命中后的回调
     * @return
     * @throws RtaRequestException
     */
    @Override
    public boolean isTarget(RtaRequest request, Consumer<Map<Object, Object>> feedback) throws RtaRequestException {
        HttpRequestBase requestBase = null;
        RtaType rtaType = getRtaType();
        try {
            requestBase = create(request);

            HttpResponse response = httpClient.execute(requestBase);
            int statusCode = response.getStatusLine().getStatusCode();

            if (statusCode != HttpStatus.SC_OK) {
                log.warn("{} - statusCode: {}", rtaType, statusCode);
            }

            byte[] bytes = EntityUtils.toByteArray(response.getEntity());
            return isTarget(request, bytes,feedback);
        } catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("{} - {}", rtaType, e.getMessage());
            }
            throw new RtaRequestException(e);
        } finally {
            if (Objects.nonNull(requestBase) && !requestBase.isAborted()) {
                requestBase.abort();
            }
        }
    }

    /**
     * 创建请求
     * @param request
     * @return
     */
    private HttpRequestBase create(RtaRequest request) {
        com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidRequest bidRequest = QiHangForApiRequestBuilder.buildRequest(request);
//        try {
//            log.info(JsonFormat.printer().print(bidRequest));
//        } catch (InvalidProtocolBufferException e) {
//            e.printStackTrace();
//        }
        HttpPost post = new HttpPost(properties.getUrl());
        post.setEntity(new ByteArrayEntity(bidRequest.toByteArray()));
        post.addHeader(HttpHeaders.CONTENT_TYPE, "application/x-protobuf;charset=UTF-8");
        return post;
    }

    /**
     * 判断返回值
     * @param request
     * @param bytes
     * @param feedback
     * @return
     */
    public boolean isTarget(RtaRequest request, byte[] bytes, Consumer<Map<Object, Object>> feedback) {
        try {
            com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidResponse qiHangResponse = com.bxm.pangu.rta.common.qihang.proto.SurgeBidding.BidResponse.parseFrom(bytes);
//            log.info(JsonFormat.printer().print(qiHangResponse));
            List<String> nurls = qiHangResponse.getSeatBidList().stream()
                    .flatMap(seatBid -> seatBid.getBidList().stream())
                    .map(SurgeBidding.BidResponse.Bid::getNurl)
                    .filter(StringUtils::isNotBlank)
                    .collect(Collectors.toList());

            if (!nurls.isEmpty() && feedback != null) {
                Map<Object, Object> res = new HashMap<>();
                res.put("nurls", nurls);
                long price = qiHangResponse.getSeatBid(0).getBid(0).getPrice();
                res.put("price",price);
                if (Math.random() < 0.1) {
                    log.info("qiHangPrice id : {} - bidId : {} - price : {} - time : {}",qiHangResponse.getId(),qiHangResponse.getBidId(),price, DateHelper.format(DateHelper.PATTERN_STR19));
                }
                feedback.accept(res);
            }
            return !qiHangResponse.getSeatBidList().isEmpty();
        } catch (InvalidProtocolBufferException e) {
            log.error("qiHang buildResponse error:", e);
            return false;
        }
    }


    @Override
    public RtaType getRtaType() {
        return RtaType.QiHangRtbForApi;
    }

    @Override
    public RtaClientProperties getProperties() {
        return properties;
    }
}
