package com.bxm.pangu.rta.common.taobao_activity;

import com.bxm.pangu.rta.common.RtaClientProperties;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * @author allen
 * @date 2021-10-13
 * @since 1.0
 */
@Data
@ConfigurationProperties(prefix = "rta.taobao-activity")
public class TaobaoActivityRtaProperties implements RtaClientProperties {

    private String url = "http://gw.api.taobao.com/router/rest";
    private String appKey = "33168426";
    private String appSecret = "0f3a00d51822e5806684f89a6300a68b";
    private int connectTimeout = 50;
    private int socketTimeout = 60;

    /**
     * Taobao SDK 是否需要开启日志。默认：false
     */
    private boolean needEnableLogger = false;

    @Override
    public List<Long> getRequestTimesForWarning() {
        return Lists.newArrayList();
    }
}
