package com.bxm.profit.model.dto;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.util.dto.CommonDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "广告收益查询参数")
public class AdIncomeLogDto extends CommonDto {

    /**
     * app广告位id
     */
    @ApiModelProperty(value = "app广告位id")
    private Long   entranceId;

    /**
     * 开发者appId
     */
    @ApiModelProperty(value = "开发者appId")
    private Long   appId;

    /**
     * 开发者appkey
     */
    @ApiModelProperty(value = "开发者appkey")
    private String appKey;

    /**
     * app广告位标识
     */
    @ApiModelProperty(value = "app广告位标识")
    private String adPositionId;

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "订单编号")
    private String orderNumber;

    /**
     * 查询收益开始时间
     */
    @ApiModelProperty(value = "查询收益开始时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date   orderTimeStartTime;
    /**
     * 查询收益结束时间
     */
    @ApiModelProperty(value = "查询收益结束时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date   orderTimeEndTime;

    /**
     * app广告位id
     * 
     * @return entrance_id app广告位id
     */
    public Long getEntranceId() {
        return entranceId;
    }

    /**
     * app广告位id
     * 
     * @param entranceId app广告位id
     */
    public void setEntranceId(Long entranceId) {
        this.entranceId = entranceId;
    }

    /**
     * 开发者appId
     * 
     * @return app_id 开发者appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * 开发者appId
     * 
     * @param appId 开发者appId
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 开发者appkey
     * 
     * @return app_key 开发者appkey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * 开发者appkey
     * 
     * @param appKey 开发者appkey
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey == null ? null : appKey.trim();
    }

    /**
     * app广告位标识
     * 
     * @return ad_position_id app广告位标识
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * app广告位标识
     * 
     * @param adPositionId app广告位标识
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId == null ? null : adPositionId.trim();
    }

    /**
     * 订单编号
     * 
     * @return order_number 订单编号
     */
    public String getOrderNumber() {
        return orderNumber;
    }

    /**
     * 订单编号
     * 
     * @param orderNumber 订单编号
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber == null ? null : orderNumber.trim();
    }

    /**
     * @return the orderTimeStartTime
     */
    public Date getOrderTimeStartTime() {
        return orderTimeStartTime;
    }

    /**
     * @param orderTimeStartTime the orderTimeStartTime to set
     */
    public void setOrderTimeStartTime(Date orderTimeStartTime) {
        this.orderTimeStartTime = orderTimeStartTime;
    }

    /**
     * @return the orderTimeEndTime
     */
    public Date getOrderTimeEndTime() {
        return orderTimeEndTime;
    }

    /**
     * @param orderTimeEndTime the orderTimeEndTime to set
     */
    public void setOrderTimeEndTime(Date orderTimeEndTime) {
        this.orderTimeEndTime = orderTimeEndTime;
    }

}
