package com.bxm.profit.model.dto;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "广告收益添加参数")
public class AddAdIncomeLogDto {

    /**
     * app广告位id
     */
    @ApiModelProperty(value = "app广告位id")
    private Long       entranceId;

    /**
     * 开发者appId
     */
    @ApiModelProperty(value = "开发者appId")
    private Long       appId;

    /**
     * 开发者appkey
     */
    @ApiModelProperty(value = "开发者appkey")
    private String     appKey;

    /**
     * app广告位标识
     */
    @ApiModelProperty(value = "app广告位标识")
    private String     adPositionId;

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "订单编号")
    private String     orderNumber;

    /**
     * 开发者收益时间
     */
    @ApiModelProperty(value = "开发者收益时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date       orderTime;

    /**
     * 开发者预计收入金额
     */
    @ApiModelProperty(value = "开发者预计收入金额")
    private BigDecimal prepareIncome = BigDecimal.ZERO;

    /**
     * 开发者收入金额
     */
    @ApiModelProperty(value = "开发者收入金额")
    private BigDecimal income        = BigDecimal.ZERO;

    /**
     * @return the entranceId
     */
    public Long getEntranceId() {
        return entranceId;
    }

    /**
     * @param entranceId the entranceId to set
     */
    public void setEntranceId(Long entranceId) {
        this.entranceId = entranceId;
    }

    /**
     * @return the appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * @param appId the appId to set
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * @return the appKey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * @param appKey the appKey to set
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * @return the adPositionId
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * @param adPositionId the adPositionId to set
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId;
    }

    /**
     * @return the orderNumber
     */
    public String getOrderNumber() {
        return orderNumber;
    }

    /**
     * @param orderNumber the orderNumber to set
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * @return the orderTime
     */
    public Date getOrderTime() {
        return orderTime;
    }

    /**
     * @param orderTime the orderTime to set
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * @return the prepareIncome
     */
    public BigDecimal getPrepareIncome() {
        return prepareIncome;
    }

    /**
     * @param prepareIncome the prepareIncome to set
     */
    public void setPrepareIncome(BigDecimal prepareIncome) {
        this.prepareIncome = prepareIncome;
    }

    /**
     * @return the income
     */
    public BigDecimal getIncome() {
        return income;
    }

    /**
     * @param income the income to set
     */
    public void setIncome(BigDecimal income) {
        this.income = income;
    }

}
