package com.bxm.profit.model.dto;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName HdfkIncomeLogDto.java
 * @Description 功能描述： 收益
 * @author leon 2017年12月29日 下午4:16:14
 * @CopyRight 杭州微财网络科技有限公司
 */
@ApiModel(description = "货到付款收益属性")
public class HdfkIncomeLogDto {

    /**
     * 时间戳
     */
    @ApiModelProperty(value = "时间戳", required = true)
    private Long       timestamp;
    /**
     * 签名
     */
    @ApiModelProperty(value = "签名", required = true)
    private String     sign;
    /**
     * appKey
     */
    @ApiModelProperty(value = "开发者appKey", required = true)
    private String     appKey;
    /**
     * 用户账信息
     */
    @ApiModelProperty(value = "用户账信息")
    private String     account;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "订单号", required = true)
    private String     orderNumber;
    /**
     * 订单金额
     */
    @ApiModelProperty(value = "订单金额", required = true)
    private BigDecimal orderAmount;
    /**
     * 收益产生时间
     */
    @ApiModelProperty(value = "收益产生时间yyyy-MM-dd HH:mm:ss格式", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date       orderTime;
    /**
     * 订单详情
     */
    @ApiModelProperty(value = "订单详情")
    private String     orderDetails;
    /**
     * 开发者预估收益
     */
    @ApiModelProperty(value = "开发者预估收益：为负数表示扣除，没有收益传0", required = true)
    private BigDecimal prepareIncome;
    /**
     * 开发者可提现收益
     */
    @ApiModelProperty(value = "开发者可提现收益：为负数表示扣除，没有收益传0", required = true)
    private BigDecimal income;
    /**
     * 变现猫收益
     */
    @ApiModelProperty(value = "变现猫收益")
    private BigDecimal bxmIncome;
    /**
     * 付款方式：1支付宝支付，2微信支付，3银联支付,4翼支付
     */
    @ApiModelProperty(value = "付款方式：1支付宝支付，2微信支付，3银联支付,4翼支付")
    private String     payMethod;

    /**
     * @return the timestamp
     */
    public Long getTimestamp() {
        return timestamp;
    }

    /**
     * @param timestamp the timestamp to set
     */
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * @return the sign
     */
    public String getSign() {
        return sign;
    }

    /**
     * @param sign the sign to set
     */
    public void setSign(String sign) {
        this.sign = sign;
    }

    /**
     * @return the appKey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * @param appKey the appKey to set
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * @return the account
     */
    public String getAccount() {
        return account;
    }

    /**
     * @param account the account to set
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * @return the orderNumber
     */
    public String getOrderNumber() {
        return orderNumber;
    }

    /**
     * @param orderNumber the orderNumber to set
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * @return the orderAmount
     */
    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    /**
     * @param orderAmount the orderAmount to set
     */
    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    /**
     * @return the orderTime
     */
    public Date getOrderTime() {
        return orderTime;
    }

    /**
     * @param orderTime the orderTime to set
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * @return the orderDetails
     */
    public String getOrderDetails() {
        return orderDetails;
    }

    /**
     * @param orderDetails the orderDetails to set
     */
    public void setOrderDetails(String orderDetails) {
        this.orderDetails = orderDetails;
    }

    /**
     * @return the prepareIncome
     */
    public BigDecimal getPrepareIncome() {
        return prepareIncome;
    }

    /**
     * @param prepareIncome the prepareIncome to set
     */
    public void setPrepareIncome(BigDecimal prepareIncome) {
        this.prepareIncome = prepareIncome;
    }

    /**
     * @return the income
     */
    public BigDecimal getIncome() {
        return income;
    }

    /**
     * @param income the income to set
     */
    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    /**
     * @return the bxmIncome
     */
    public BigDecimal getBxmIncome() {
        return bxmIncome;
    }

    /**
     * @param bxmIncome the bxmIncome to set
     */
    public void setBxmIncome(BigDecimal bxmIncome) {
        this.bxmIncome = bxmIncome;
    }

    /**
     * @return the payMethod
     */
    public String getPayMethod() {
        return payMethod;
    }

    /**
     * @param payMethod the payMethod to set
     */
    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

}
