package com.bxm.profit.model.dto;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName IncomeLogDto.java
 * @Description 功能描述： 收益
 * @author leon 2017年12月29日 下午4:16:14
 * @CopyRight 杭州微财网络科技有限公司
 */
@ApiModel(description = "收益属性")
public class IncomeLogDto {

    /**
     * appKey
     */
    @ApiModelProperty(value = "开发者appKey")
    private String     appKey;
    /**
     * 用户账信息
     */
    @ApiModelProperty(value = "用户账信息")
    private String     account;
    /**
     * 产品业务id：1夺宝 ，2直播，3爆款特卖，4广告，5书城，6娃娃机，7搞笑段子，8福利社，9积分商城，10借贷超市
     */
    @ApiModelProperty(value = "产品业务id：1夺宝 ，2直播，3爆款特卖，4广告，5书城，6娃娃机，7搞笑段子，8福利社，9积分商城，10借贷超市")
    private Integer    productId;

    /**
     * 灵机测算用作渠道id
     */
    @ApiModelProperty("灵机测算用作渠道id")
    private Integer    relatedProductId;

    /**
     * 订单号
     */
    @ApiModelProperty(value = "订单号")
    private String     orderNumber;
    /**
     * 订单金额
     */
    @ApiModelProperty(value = "订单金额")
    private BigDecimal orderAmount;
    /**
     * 收益产生时间
     */
    @ApiModelProperty(value = "收益产生时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date       orderTime;
    /**
     * 订单详情
     */
    @ApiModelProperty(value = "订单详情")
    private String     orderDetails;
    /**
     * 开发者预估收益
     */
    @ApiModelProperty(value = "开发者预估收益")
    private BigDecimal prepareIncome = BigDecimal.ZERO;
    /**
     * 开发者可提现收益
     */
    @ApiModelProperty(value = "开发者可提现收益")
    private BigDecimal income        = BigDecimal.ZERO;
    /**
     * 变现猫收益
     */
    @ApiModelProperty(value = "变现猫收益")
    private BigDecimal bxmIncome     = BigDecimal.ZERO;
    /**
     * 付款方式：1支付宝支付，2微信支付，3银联支付,4翼支付
     */
    @ApiModelProperty(value = "付款方式：1支付宝支付，2微信支付，3银联支付,4翼支付")
    private String     payMethod;

    /**
     * @return the appKey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * @param appKey the appKey to set
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    /**
     * @return the account
     */
    public String getAccount() {
        return account;
    }

    /**
     * @param account the account to set
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * @return the productId
     */
    public Integer getProductId() {
        return productId;
    }

    /**
     * @param productId the productId to set
     */
    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    /**
     * @return the relatedProductId
     */
    public Integer getRelatedProductId() {
        return relatedProductId;
    }

    /**
     * @param relatedProductId the relatedProductId to set
     */
    public void setRelatedProductId(Integer relatedProductId) {
        this.relatedProductId = relatedProductId;
    }

    /**
     * @return the orderNumber
     */
    public String getOrderNumber() {
        return orderNumber;
    }

    /**
     * @param orderNumber the orderNumber to set
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    /**
     * @return the orderAmount
     */
    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    /**
     * @param orderAmount the orderAmount to set
     */
    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    /**
     * @return the orderTime
     */
    public Date getOrderTime() {
        return orderTime;
    }

    /**
     * @param orderTime the orderTime to set
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * @return the orderDetails
     */
    public String getOrderDetails() {
        return orderDetails;
    }

    /**
     * @param orderDetails the orderDetails to set
     */
    public void setOrderDetails(String orderDetails) {
        this.orderDetails = orderDetails;
    }

    /**
     * @return the prepareIncome
     */
    public BigDecimal getPrepareIncome() {
        return prepareIncome;
    }

    /**
     * @param prepareIncome the prepareIncome to set
     */
    public void setPrepareIncome(BigDecimal prepareIncome) {
        this.prepareIncome = prepareIncome;
    }

    /**
     * @return the income
     */
    public BigDecimal getIncome() {
        return income;
    }

    /**
     * @param income the income to set
     */
    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    /**
     * @return the bxmIncome
     */
    public BigDecimal getBxmIncome() {
        return bxmIncome;
    }

    /**
     * @param bxmIncome the bxmIncome to set
     */
    public void setBxmIncome(BigDecimal bxmIncome) {
        this.bxmIncome = bxmIncome;
    }

    /**
     * @return the payMethod
     */
    public String getPayMethod() {
        return payMethod;
    }

    /**
     * @param payMethod the payMethod to set
     */
    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

}
