/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.profit.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 类BxmProductEnum.java的实现描述：变现猫产品业务
 * 
 * @author leon 2017年5月18日 上午11:54:35
 */
public enum BxmProductEnum {

                            /**
                             * 夺宝
                             */
                            DUO_BAO(1, "其他"),
                            /**
                             * 直播
                             */
                            LIVE(2, "直播"),
                            /**
                             * 爆款特卖
                             */
                            BUY(3, "爆款特卖"),
                            /**
                             * 广告
                             */
                            AD(4, "广告"),
                            /**
                             * 书城
                             */
                            BOOK(5, "书城"),
                            /**
                             * 娃娃机
                             */
                            GAME(6, "娃娃机"),
                            /**
                             * 爆笑一刻
                             */
                            JOKE(7, "爆笑一刻"),
                            /**
                             * 新广告(福利社)
                             */
                            FU_LI(8, "福利社"),
                            /**
                             * 新广告(积分商城)
                             */
                            JI_FEN(9, "积分商城"),
                            /**
                             * 借贷超市
                             */
                            LOANSHOP(10, "借贷超市"),
                            /**
                             * 本地头条
                             */
                            NEWS(11, "本地头条"),
                            /**
                             * 货到付款
                             */
                            GUESS(12, "灵机测算"),
                            /**
                             * 货到付款
                             */
                            HDFK(13, "货到付款");

    private int    code;

    private String name;

    /**
     * @param code
     * @param name
     */
    private BxmProductEnum(int code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * 所有状态
     * 
     * @return
     */
    public static Map<Integer, String> getAllState() {
        BxmProductEnum[] sts = BxmProductEnum.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (BxmProductEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     * 
     * @param code
     * @return
     */
    public static String getName(int code) {
        for (BxmProductEnum state : BxmProductEnum.values()) {
            if (state.getCode() == code) {
                return state.getName();
            }
        }
        return "状态异常";
    }

}
