package com.bxm.profit.model.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "广告收益展示字段")
public class AdIncomeLogVo {

    /**
     * app广告位id
     */
    @ApiModelProperty(value = "app广告位id")
    private Long       entranceId;

    /**
     * 开发者appId
     */
    @ApiModelProperty(value = "开发者appId")
    private Long       appId;

    /**
     * 开发者appkey
     */
    @ApiModelProperty(value = "开发者appkey")
    private String     appKey;

    /**
     * app广告位标识
     */
    @ApiModelProperty(value = "app广告位标识")
    private String     adPositionId;

    /**
     * 订单编号
     */
    @ApiModelProperty(value = "订单编号")
    private String     orderNumber;

    /**
     * 开发者收益时间
     */
    @ApiModelProperty(value = "开发者收益时间")
    private Date       orderTime;

    /**
     * 开发者预计收入金额
     */
    @ApiModelProperty(value = "开发者预计收入金额")
    private BigDecimal prepareIncome;

    /**
     * 开发者收入金额
     */
    @ApiModelProperty(value = "开发者收入金额")
    private BigDecimal income;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date       created;

    /**
     * app广告位id
     * 
     * @return entrance_id app广告位id
     */
    public Long getEntranceId() {
        return entranceId;
    }

    /**
     * app广告位id
     * 
     * @param entranceId app广告位id
     */
    public void setEntranceId(Long entranceId) {
        this.entranceId = entranceId;
    }

    /**
     * 开发者appId
     * 
     * @return app_id 开发者appId
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * 开发者appId
     * 
     * @param appId 开发者appId
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 开发者appkey
     * 
     * @return app_key 开发者appkey
     */
    public String getAppKey() {
        return appKey;
    }

    /**
     * 开发者appkey
     * 
     * @param appKey 开发者appkey
     */
    public void setAppKey(String appKey) {
        this.appKey = appKey == null ? null : appKey.trim();
    }

    /**
     * app广告位标识
     * 
     * @return ad_position_id app广告位标识
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * app广告位标识
     * 
     * @param adPositionId app广告位标识
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId == null ? null : adPositionId.trim();
    }

    /**
     * 订单编号
     * 
     * @return order_number 订单编号
     */
    public String getOrderNumber() {
        return orderNumber;
    }

    /**
     * 订单编号
     * 
     * @param orderNumber 订单编号
     */
    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber == null ? null : orderNumber.trim();
    }

    /**
     * 开发者收益时间
     * 
     * @return order_time 开发者收益时间
     */
    public Date getOrderTime() {
        return orderTime;
    }

    /**
     * 开发者收益时间
     * 
     * @param orderTime 开发者收益时间
     */
    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    /**
     * 开发者预计收入金额
     * 
     * @return prepare_income 开发者预计收入金额
     */
    public BigDecimal getPrepareIncome() {
        return prepareIncome;
    }

    /**
     * 开发者预计收入金额
     * 
     * @param prepareIncome 开发者预计收入金额
     */
    public void setPrepareIncome(BigDecimal prepareIncome) {
        this.prepareIncome = prepareIncome;
    }

    /**
     * 开发者收入金额
     * 
     * @return income 开发者收入金额
     */
    public BigDecimal getIncome() {
        return income;
    }

    /**
     * 开发者收入金额
     * 
     * @param income 开发者收入金额
     */
    public void setIncome(BigDecimal income) {
        this.income = income;
    }

    /**
     * 创建时间
     * 
     * @return created 创建时间
     */
    public Date getCreated() {
        return created;
    }

    /**
     * 创建时间
     * 
     * @param created 创建时间
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setCreated(Date created) {
        this.created = created;
    }

}
