/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.facade.BoostService;
import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.boost.BoostDetailVo;
import com.bxm.shop.facade.model.boost.CreateBoostRo;
import com.bxm.shop.facade.model.goods.FreeGoodsVo;
import com.bxm.warcar.utils.response.ResultModel;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/boost"})
@RestController
public class BoostController {
    private static final Logger log = LoggerFactory.getLogger(BoostController.class);
    @Resource
    private BoostService boostService;

    @RequestMapping(value={"/goodsList"})
    public ResultModel<FreeGoodsVo> list(@RequestHeader(value="openid") String openid) {
        return this.boostService.list(openid);
    }

    @RequestMapping(value={"/getDetail"})
    public ResultModel<BoostDetailVo> detail(@RequestHeader(value="openid") String openid, Long boostId) {
        return this.boostService.detail(openid, boostId);
    }

    @RequestMapping(value={"/boost"})
    public ResultModel boost(@RequestHeader(value="openid") String openid, String boostId) {
        return this.boostService.boost(openid, boostId);
    }

    @RequestMapping(value={"/createBoost"})
    public ResultModel<Long> createBoost(@HeadParamOpenid CreateBoostRo createBoostRo) {
        return this.boostService.createBoost(createBoostRo);
    }
}

