/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.counter.CounterDto;
import com.bxm.shop.integration.CounterServiceIntegration;
import com.bxm.warcar.utils.response.ResultModel;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/counter"})
@RestController
public class CounterController {
    @Autowired
    private CounterServiceIntegration counterServiceIntegration;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("CounterController-pool-%d").build());
    private static final String COUNTER_TYPE = "entrance";

    @RequestMapping(value={"count"})
    public ResultModel count(@HeadParamOpenid CounterDto dto) {
        ResultModel rs = new ResultModel();
        this.poolExecutor.execute(() -> {
            dto.setType(COUNTER_TYPE);
            this.counterServiceIntegration.count(dto);
        });
        return rs;
    }

    @RequestMapping(value={"countAndRedirect"})
    public void countAndRedirect(@HeadParamOpenid CounterDto dto, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        dto.setBxmId(dto.getBxm_id());
        this.poolExecutor.execute(() -> {
            dto.setType(COUNTER_TYPE);
            this.counterServiceIntegration.count(dto);
        });
        try {
            response.sendRedirect(dto.getRedirectUrl());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

