/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.facade.model.goods.GoodsVo;
import com.bxm.shop.integration.FavoriteServiceIntegration;
import com.bxm.shop.utils.BeanValidator;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/favorite"})
public class FavoriteController {
    @Autowired
    private FavoriteServiceIntegration favoriteServiceIntegration;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @RequestMapping(value={"/add"})
    public ResultModel add(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Common.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.favoriteServiceIntegration.add(dto);
    }

    @RequestMapping(value={"/cancel"})
    public ResultModel cancel(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Common.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.favoriteServiceIntegration.cancel(dto);
    }

    @RequestMapping(value={"/isFavorite"})
    public ResultModel<Boolean> isFavorite(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Common.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        ResultModel rs = new ResultModel();
        String redisKey = RedisConstants.Favorite.getMyFavorite(dto.getOpenid()).generateKey();
        rs.setReturnValue((Object)(this.stringRedisTemplate.opsForZSet().rank((Object)redisKey, (Object)dto.getGoodsId()) != null ? 1 : 0));
        return rs;
    }

    @RequestMapping(value={"/list"})
    public ResultModel<List<GoodsVo>> list(@RequestHeader(value="openid") String openid) {
        return this.favoriteServiceIntegration.list(openid);
    }
}

