/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.integration.FriendServiceIntegration;
import com.bxm.shop.utils.BeanValidator;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import javax.validation.ConstraintViolation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/friend"})
@RestController
public class FriendController {
    @Autowired
    private FriendServiceIntegration friendServiceIntegration;

    @RequestMapping(value={"/info"})
    public ResultModel info(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Openid.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.friendServiceIntegration.info(dto);
    }

    @RequestMapping(value={"/findDirectFriends"})
    public ResultModel findDirectFriends(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Openid.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.friendServiceIntegration.findDirectFriends(dto);
    }

    @RequestMapping(value={"/findIndirectFriends"})
    public ResultModel findIndirectFriends(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Openid.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.friendServiceIntegration.findIndirectFriends(dto);
    }
}

