/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.exception.EnhanceResultModel;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.facade.GoodsService;
import com.bxm.shop.facade.model.Banner;
import com.bxm.shop.facade.model.common.Page;
import com.bxm.shop.facade.model.goods.GoodsDetailVo;
import com.bxm.shop.facade.model.goods.GoodsPoolVO;
import com.bxm.shop.facade.model.goods.GoodsQueryRo;
import com.bxm.shop.facade.model.goods.GoodsVo;
import com.bxm.shop.facade.model.goods.ThemeGoodsVo;
import com.bxm.shop.facade.model.tag.TagVo;
import com.bxm.warcar.utils.response.ResultModel;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/home"})
public class HomeController {
    private static final Logger log = LoggerFactory.getLogger(HomeController.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private GoodsService goodsService;

    @GetMapping(value={"/getTags"})
    public ResultModel<List<TagVo>> getTags() {
        return this.goodsService.getTags();
    }

    @GetMapping(value={"/getBanners"})
    public ResultModel<List<Banner>> getBanners() {
        EnhanceResultModel<List<Object>> result = new EnhanceResultModel<List<Banner>>();
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)"MINIPROGRAM:BANNER:LIST");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            result.setReturnValue(JSONObject.parseArray((String)json, Banner.class));
            return result;
        }
        result = new EnhanceResultModel(ResponseCodeType.DATA_ANOMALY, new String[0]);
        log.error("banner\u914d\u7f6e\u4e3a\u7a7a,redisKey={}", (Object)"MINIPROGRAM:BANNER:LIST");
        return result;
    }

    @GetMapping(value={"/getGoodsList"})
    public ResultModel<Page<GoodsVo>> getGoodsList(GoodsQueryRo goodsQueryRo) {
        return this.goodsService.getGoodsList(goodsQueryRo);
    }

    @GetMapping(value={"/getBlocks"})
    public ResultModel<List<Banner>> getBlocks() {
        EnhanceResultModel<List<Object>> result = new EnhanceResultModel<List<Banner>>();
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)"MINIPROGRAM:CHANNEL:LIST");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            result.setReturnValue(JSONObject.parseArray((String)json, Banner.class));
            return result;
        }
        result = new EnhanceResultModel(ResponseCodeType.DATA_ANOMALY, new String[0]);
        log.error("\u9996\u9875\u680f\u76ee\u914d\u7f6e\u4e3a\u7a7a,redisKey={}", (Object)"MINIPROGRAM:CHANNEL:LIST");
        return result;
    }

    @GetMapping(value={"/getChannelPool"})
    public ResultModel<GoodsPoolVO> getChannelPool(Long id) {
        return this.goodsService.getGoodsPoolById(id);
    }

    @GetMapping(value={"/getThemeGoodsList"})
    public ResultModel<ThemeGoodsVo> getThemeGoodsList(Long goodsPoolId) {
        return this.goodsService.getThemeGoodsList(goodsPoolId);
    }

    @GetMapping(value={"/getPops"})
    public ResultModel<List<GoodsDetailVo.Pop>> getPops() {
        return this.goodsService.getPops();
    }
}

