/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.utils.AESUtil;
import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.user.UserDto;
import com.bxm.shop.facade.model.user.UserVo;
import com.bxm.shop.integration.UserServiceIntegration;
import com.bxm.shop.utils.BeanValidator;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private UserServiceIntegration userServiceIntgration;

    @RequestMapping(value={"/wxlogin"})
    public ResultModel<UserVo> login(UserDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, UserDto.Code.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.userServiceIntgration.login(dto);
    }

    @RequestMapping(value={"/update"})
    public ResultModel update(@HeadParamOpenid UserDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, UserDto.Openid.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.userServiceIntgration.update(dto);
    }

    @RequestMapping(value={"/updateMobile"})
    public ResultModel<String> updateMobile(@RequestHeader(value="openid") String openId, @RequestHeader(value="sessionId") String sessionKey, @RequestParam(value="encrypted") String encrypted, @RequestParam(value="iv") String iv) {
        String phoneNumber;
        if (StringUtils.isBlank((CharSequence)openId)) {
            return ResultModelFactory.FAILED400((String)"openId\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)encrypted)) {
            return ResultModelFactory.FAILED400((String)"encrypted\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)sessionKey)) {
            return ResultModelFactory.FAILED400((String)"sessionKey\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)iv)) {
            return ResultModelFactory.FAILED400((String)"iv\u4e3a\u7a7a");
        }
        try {
            String json = AESUtil.wxDecrypt(encrypted, sessionKey, iv);
            phoneNumber = JSONObject.parseObject((String)json).getString("phoneNumber");
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u624b\u673a\u53f7\u5f02\u5e38");
            return ResultModelFactory.FAILED400((String)"\u89e3\u5bc6\u624b\u673a\u53f7\u5f02\u5e38");
        }
        UserDto userDto = new UserDto();
        userDto.setOpenid(openId);
        userDto.setMobile(phoneNumber);
        ResultModel resultModel = this.userServiceIntgration.update(userDto);
        resultModel.setReturnValue((Object)phoneNumber);
        return resultModel;
    }
}

