/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.facade.model.counter.CounterDto;
import com.bxm.shop.integration.CounterServiceIntegration;
import com.bxm.shop.integration.WechatServiceIntegration;
import com.bxm.warcar.cache.Fetcher;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mini"})
public class MiniProgramController {
    private static final Logger log = LoggerFactory.getLogger(MiniProgramController.class);
    private static final String DEFAULT_PIC_URL = "https://m.cudaojia.com/dist/ACTIVITY/certificate/2018/12/21/824d4986-fb15-4cf9-8af6-0e0b5392ae80";
    private static final String GET_WXACODE_UNLIMIT_URL = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=";
    private static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");
    private OkHttpClient mOkHttpClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();
    @Autowired
    private WechatServiceIntegration wechatServiceIntegration;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private CounterServiceIntegration counterServiceIntegration;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new ThreadFactoryBuilder().setNameFormat("CounterController-pool-%d").build());
    private static final String COUNTER_TYPE = "generate";

    @RequestMapping(value={"/getQrcode"})
    public void getQrode(String bxmId, String type, HttpServletResponse rs) {
        this.poolExecutor.execute(() -> {
            CounterDto dto = new CounterDto();
            dto.setBxmId(bxmId);
            dto.setType(COUNTER_TYPE);
            this.counterServiceIntegration.count(dto);
        });
        if (StringUtils.isEmpty((String)bxmId)) {
            this.getDefaultCode(rs);
            return;
        }
        String accessToken = this.wechatServiceIntegration.getAccessToken();
        if (null != accessToken) {
            boolean result = this.getCodeByBxmId(rs, accessToken, bxmId, type);
            if (!result) {
                accessToken = this.wechatServiceIntegration.refreshAccessToken();
                this.getCodeByBxmId(rs, accessToken, bxmId, type);
            }
            return;
        }
        this.getDefaultCode(rs);
    }

    private boolean getCodeByBxmId(HttpServletResponse rs, String accessToken, String bxmId, String type) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("scene", (Object)bxmId);
        if ("zero".equals(type)) {
            jsonObject.put("page", (Object)"pages/newFree/newFree");
        } else {
            jsonObject.put("page", (Object)"pages/home/home");
        }
        RequestBody body = RequestBody.create(JSON, jsonObject.toJSONString());
        Request request = new Request.Builder().url(GET_WXACODE_UNLIMIT_URL + accessToken).post(body).build();
        try {
            Response response = this.mOkHttpClient.newCall(request).execute();
            if (null != response.body() && response.body().contentLength() < 500L) {
                return Boolean.FALSE;
            }
            InputStream inputStream = response.body().byteStream();
            ServletOutputStream outputStream = rs.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
            inputStream.close();
            response.body().close();
            response.close();
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void getDefaultCode(HttpServletResponse rs) {
        Request defaultRequest = new Request.Builder().url(DEFAULT_PIC_URL).get().build();
        try {
            Response response = this.mOkHttpClient.newCall(defaultRequest).execute();
            InputStream inputStream = response.body().byteStream();
            ServletOutputStream outputStream = rs.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

