/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.facade.OrderService;
import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.integration.OrderServiceIntegration;
import com.bxm.shop.utils.BeanValidator;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import javax.validation.ConstraintViolation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/order"})
@RestController
public class OrderController {
    @Autowired
    private OrderServiceIntegration orderServiceIntegration;
    @Autowired
    private OrderService orderService;

    @RequestMapping(value={"/add"})
    public ResultModel add(@HeadParamOpenid OrderDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Common.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.orderServiceIntegration.add(dto);
    }

    @RequestMapping(value={"/find"})
    public ResultModel find(@HeadParamOpenid OrderDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Order.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        if (dto.getPageNum() == null || dto.getPageNum() < 1) {
            dto.setPageNum(Integer.valueOf(1));
        }
        if (dto.getPageSize() == null || dto.getPageSize() < 1) {
            dto.setPageSize(Integer.valueOf(10));
        }
        return this.orderService.find(dto);
    }
}

