/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.shop.facade.model.share.vo.ShareInfoVo;
import com.bxm.shop.integration.UserShareServiceIntegration;
import com.bxm.shop.utils.BeanValidator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/share"})
public class ShareController {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private UserShareServiceIntegration userShareServiceIntegration;

    @RequestMapping(value={"/add"})
    public ResultModel add(@HeadParamOpenid CommonDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, CommonDto.Common.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        return this.userShareServiceIntegration.add(dto);
    }

    @RequestMapping(value={"/getShareInfo"})
    public ResultModel getShareInfo(String type) {
        ShareInfoVo shareInfoVo;
        ResultModel rs = new ResultModel();
        if (StringUtils.isBlank((CharSequence)type)) {
            type = "default";
        }
        if (null == (shareInfoVo = (ShareInfoVo)this.fetcher.hfetch(RedisConstants.Share.getShareInfo(), type, ShareInfoVo.class))) {
            shareInfoVo = (ShareInfoVo)this.fetcher.hfetch(RedisConstants.Share.getShareInfo(), "default", ShareInfoVo.class);
        }
        rs.setReturnValue((Object)shareInfoVo);
        return rs;
    }

    @RequestMapping(value={"/callback"})
    public ResultModel callback(@RequestHeader(value="openid") String openid) {
        return this.userShareServiceIntegration.callback(openid);
    }
}

