/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.tinify.Tinify;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Service
public class UploadImgService {
    private static final Logger log = LoggerFactory.getLogger(UploadImgService.class);
    private static final String imgFileHost = "https://buyimg.bianxianmao.com/";
    private static final String bucketName = "bxm-guide";
    private static final String[] IMG_KEY = new String[]{"2lku16Gahn1ASIUr02kPEYb0GJJC_lng", "2fKMylTj9-EWJbytvskmZjRptTaelqXl", "QoWNCAkiMTel_u4i3r0Tw89ehJ5EDdhV", "nU95cN3Sn9UJGgQQi0GtdM41X0avdO5D", "ZRNxPVBTx892tpMdXw7GJhkeyTLJ-tqn", "sQ2gXIxBfzXQzb3QT50ReAxkBIql7aZG"};
    @Value(value="${aliOSS.endPoint}")
    private String END_POINT;
    @Value(value="${aliOSS.accessKeyId}")
    private String ACCESS_KEY_ID;
    @Value(value="${aliOSS.accessKeySecret}")
    private String ACCESS_KEY_SECRET;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object uploadImg(HttpServletResponse response, HttpServletRequest request, String path) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> files = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null) continue;
                String fileName = file.getOriginalFilename();
                String suffixNmae = fileName.substring(fileName.indexOf("."));
                if (fileName.trim() == "") continue;
                File newFile = new File(request.getSession().getServletContext().getRealPath("/") + fileName);
                try {
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    file.transferTo(newFile);
                    String fileUrl = "dist/PDDMINIPROGRAM/" + path + "/" + LocalDate.now().toString() + "/" + UploadImgService.getUuidByJdk(false) + suffixNmae;
                    files.add(this.upload(newFile, bucketName, imgFileHost, fileUrl));
                }
                catch (IOException | IllegalStateException var14) {
                    log.error(var14.getMessage());
                    var14.printStackTrace();
                    Object var13_14 = null;
                    return var13_14;
                }
                finally {
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                }
            }
        }
        String rs = "[";
        for (String url : files) {
            rs = rs + "{\"url\":\"" + url + "\"}";
        }
        rs = rs + "]";
        return JSON.parse((String)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(File file, String bucketName, String imgFileHost, String fileUrl) throws ClientException {
        if (file == null) {
            return null;
        }
        OSSClient ossClient = new OSSClient(this.END_POINT, this.ACCESS_KEY_ID, this.ACCESS_KEY_SECRET);
        try {
            PutObjectResult result;
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            if (null != (result = ossClient.putObject(new PutObjectRequest(bucketName, fileUrl, file)))) {
                String string = imgFileHost + fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public String upload(InputStream inputStream, String bucketName, String imgFileHost, String path) throws FileNotFoundException, ClientException {
        if (inputStream == null) {
            return null;
        }
        OSSClient ossClient = new OSSClient(this.END_POINT, this.ACCESS_KEY_ID, this.ACCESS_KEY_SECRET);
        try {
            String fileUrl;
            PutObjectResult result;
            if (!ossClient.doesBucketExist(bucketName)) {
                ossClient.createBucket(bucketName);
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                createBucketRequest.setCannedACL(CannedAccessControlList.PublicRead);
                ossClient.createBucket(createBucketRequest);
            }
            if (null != (result = ossClient.putObject(new PutObjectRequest(bucketName, fileUrl = path, inputStream)))) {
                String string = imgFileHost + fileUrl;
                return string;
            }
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        finally {
            ossClient.shutdown();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> uploadImgMutl(HttpServletRequest request, String path, org.apache.log4j.Logger logger) {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> files = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String fileNamet = (String)iter.next();
                List filesList = multiRequest.getFiles(fileNamet);
                for (MultipartFile file : filesList) {
                    if (file == null) continue;
                    String fileName = file.getOriginalFilename();
                    String suffixNmae = fileName.substring(fileName.indexOf("."));
                    if (fileName.trim() == "") continue;
                    File newFile = new File(request.getSession().getServletContext().getRealPath("/") + fileName);
                    try {
                        if (!newFile.exists()) {
                            newFile.createNewFile();
                        }
                        file.transferTo(newFile);
                        String fileUrl = "dist/ACTIVITY/" + path + "/" + LocalDate.now().toString() + "/" + UploadImgService.getUuidByJdk(false) + suffixNmae;
                        files.add(this.upload(newFile, bucketName, imgFileHost, fileUrl));
                    }
                    catch (IOException | IllegalStateException var14) {
                        logger.error((Object)var14.getMessage());
                        var14.printStackTrace();
                        List<String> list = null;
                        return list;
                    }
                    finally {
                        if (!newFile.exists()) continue;
                        newFile.delete();
                    }
                }
            }
        }
        return files;
    }

    private static String getUuidByJdk(boolean is32bit) {
        String uuid = UUID.randomUUID().toString();
        if (is32bit) {
            return uuid.toString().replace("-", "");
        }
        return uuid;
    }

    private static byte[] compressionFromUrl(String apiKey, String url) throws IOException {
        Tinify.setKey((String)apiKey);
        return Tinify.fromUrl((String)url).toBuffer();
    }
}

