/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.controller;

import com.bxm.shop.facade.annotations.HeadParamOpenid;
import com.bxm.shop.facade.model.wallet.WalletDto;
import com.bxm.shop.integration.WalletServiceIntegration;
import com.bxm.shop.utils.BeanValidator;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import javax.validation.ConstraintViolation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wallet"})
public class WalletController {
    @Autowired
    private WalletServiceIntegration walletServiceIntegration;

    @RequestMapping(value={"/withdraw"})
    public ResultModel withdraw(@HeadParamOpenid WalletDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, WalletDto.Withdraw.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        ResultModel rs = this.walletServiceIntegration.withdraw(dto);
        return rs;
    }

    @RequestMapping(value={"/info"})
    public ResultModel info(@HeadParamOpenid WalletDto dto) {
        ConstraintViolation<?> constraintViolation = BeanValidator.validateGroup(dto, WalletDto.Openid.class);
        if (constraintViolation != null) {
            return ResultModelFactory.FAILED400((String)constraintViolation.getMessage());
        }
        ResultModel rs = this.walletServiceIntegration.info(dto);
        return rs;
    }
}

