/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.interceptor;

import com.bxm.shop.common.exception.RedisConstants;
import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.utils.NetUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@Order(value=2)
public class LoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        String sessionId = httpServletRequest.getHeader("sessionId");
        String openId = httpServletRequest.getHeader("openid");
        if (StringUtils.isBlank((CharSequence)sessionId) || StringUtils.isBlank((CharSequence)openId)) {
            NetUtils.sendErrorMsg(httpServletResponse, ResponseCodeType.USER_NOT_LOGIN);
            return false;
        }
        String userKey = RedisConstants.User.getSessionId(openId, sessionId).generateKey();
        if (this.stringRedisTemplate.hasKey((Object)userKey).booleanValue()) {
            this.stringRedisTemplate.expire((Object)userKey, 1L, TimeUnit.HOURS);
            return true;
        }
        NetUtils.sendErrorMsg(httpServletResponse, ResponseCodeType.USER_NOT_LOGIN);
        log.debug("\u7528\u6237\u672a\u767b\u5f55:redisKey={}", (Object)userKey);
        return false;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

