/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.interceptor;

import com.bxm.shop.common.exception.ResponseCodeType;
import com.bxm.shop.common.utils.MD5Util;
import com.bxm.shop.common.utils.NetUtils;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@Order(value=1)
public class SecurityInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SecurityInterceptor.class);

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        String sign = httpServletRequest.getHeader("sign");
        if (StringUtils.isBlank((CharSequence)sign)) {
            NetUtils.sendErrorMsg(httpServletResponse, ResponseCodeType.CHECK_SIGN_FAIL);
            return false;
        }
        Map paramMap = httpServletRequest.getParameterMap();
        TreeMap sortMap = new TreeMap(paramMap);
        StringBuilder sb = new StringBuilder("bxm");
        for (Map.Entry entry : sortMap.entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value == null || value.length <= 0) continue;
            boolean isEmpty = true;
            for (String s : value) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                isEmpty = false;
            }
            if (isEmpty) continue;
            sb.append((String)entry.getKey());
            for (String s : value) {
                sb.append(s);
            }
        }
        String checkSign = MD5Util.gen(sb.toString());
        if (!sign.equalsIgnoreCase(checkSign)) {
            log.debug("\u9a8c\u7b7e\u5931\u8d25:sign={}, params={}, exceptSign={}", new Object[]{sign, sb.toString(), checkSign});
            NetUtils.sendErrorMsg(httpServletResponse, ResponseCodeType.CHECK_SIGN_FAIL);
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

