/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shop.resolver;

import com.bxm.shop.facade.annotations.HeadParamOpenid;
import java.lang.reflect.Field;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class OpenidResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(HeadParamOpenid.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Field[] superFields;
        Class targetType = parameter.getParameterType();
        Field[] fields = targetType.getDeclaredFields();
        Object target = targetType.newInstance();
        WebDataBinder binder = binderFactory.createBinder(webRequest, null, "");
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            if ("openid".equals(fieldName)) {
                String openId = webRequest.getHeader("openid");
                field.set(target, openId);
                continue;
            }
            Object value = binder.convertIfNecessary((Object)webRequest.getParameter(fieldName), fieldType, parameter);
            field.set(target, value);
        }
        for (Field field : superFields = targetType.getSuperclass().getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            if ("openid".equals(fieldName)) {
                String openId = webRequest.getHeader("openid");
                field.set(target, openId);
                continue;
            }
            Object value = binder.convertIfNecessary((Object)webRequest.getParameter(fieldName), fieldType, parameter);
            field.set(target, value);
        }
        return target;
    }
}

