/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class AuthConfigFactoryImpl
extends AuthConfigFactory {
    private static final Log log = LogFactory.getLog(AuthConfigFactoryImpl.class);
    private static final StringManager sm = StringManager.getManager(AuthConfigFactoryImpl.class);
    private static final String CONFIG_PATH = "conf/jaspic-providers.xml";
    private static final File CONFIG_FILE = new File(System.getProperty("catalina.base"), "conf/jaspic-providers.xml");
    private static final Object CONFIG_FILE_LOCK = new Object();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, RegistrationContextImpl> registrations = new ConcurrentHashMap<String, RegistrationContextImpl>();

    public AuthConfigFactoryImpl() {
        this.loadPersistentRegistrations();
    }

    @Override
    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        String registrationID = this.getRegistrationID(layer, appContext);
        RegistrationContextImpl registrationContext = this.registrations.get(registrationID);
        if (registrationContext != null) {
            registrationContext.addListener(null);
            return registrationContext.getProvider();
        }
        return null;
    }

    @Override
    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        String registrationID = this.doRegisterConfigProvider(className, properties, layer, appContext, description);
        this.savePersistentRegistrations();
        return registrationID;
    }

    private String doRegisterConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        Class<?> clazz;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("authConfigFactoryImpl.registerClass", className, layer, appContext));
        }
        AuthConfigProvider provider = null;
        try {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(Map.class, AuthConfigFactory.class);
            provider = (AuthConfigProvider)constructor.newInstance(properties, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SecurityException(e);
        }
        String registrationID = this.getRegistrationID(layer, appContext);
        this.registrations.put(registrationID, new RegistrationContextImpl(layer, appContext, description, true, provider, properties));
        return registrationID;
    }

    @Override
    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("authConfigFactoryImpl.registerInstance", provider.getClass().getName(), layer, appContext));
        }
        String registrationID = this.getRegistrationID(layer, appContext);
        this.registrations.put(registrationID, new RegistrationContextImpl(layer, appContext, description, false, provider, null));
        return registrationID;
    }

    @Override
    public boolean removeRegistration(String registrationID) {
        return this.registrations.remove(registrationID) != null;
    }

    @Override
    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        String registrationID = this.getRegistrationID(layer, appContext);
        RegistrationContextImpl registrationContext = this.registrations.get(registrationID);
        if (registrationContext.removeListener(listener)) {
            return new String[]{registrationID};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        if (provider == null) {
            return this.registrations.keySet().toArray(EMPTY_STRING_ARRAY);
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry<String, RegistrationContextImpl> entry : this.registrations.entrySet()) {
            if (!provider.equals(entry.getValue().getProvider())) continue;
            results.add(entry.getKey());
        }
        return results.toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return this.registrations.get(registrationID);
    }

    @Override
    public void refresh() {
        this.loadPersistentRegistrations();
    }

    private String getRegistrationID(String layer, String appContext) {
        return layer + ":" + appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPersistentRegistrations() {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("authConfigFactoryImpl.load", CONFIG_FILE.getAbsolutePath()));
            }
            if (!CONFIG_FILE.isFile()) {
                return;
            }
            PersistentProviderRegistrations.Providers providers = PersistentProviderRegistrations.loadProviders(CONFIG_FILE);
            for (PersistentProviderRegistrations.Provider provider : providers.getProviders()) {
                this.doRegisterConfigProvider(provider.getClassName(), provider.getProperties(), provider.getLayer(), provider.getAppContext(), provider.getDescription());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePersistentRegistrations() {
        Object object = CONFIG_FILE_LOCK;
        synchronized (object) {
            PersistentProviderRegistrations.Providers providers = new PersistentProviderRegistrations.Providers();
            for (Map.Entry<String, RegistrationContextImpl> entry : this.registrations.entrySet()) {
                if (!entry.getValue().isPersistent()) continue;
                PersistentProviderRegistrations.Provider provider = new PersistentProviderRegistrations.Provider();
                provider.setAppContext(entry.getValue().getAppContext());
                provider.setClassName(entry.getValue().getProvider().getClass().getName());
                provider.setDescription(entry.getValue().getDescription());
                provider.setLayer(entry.getValue().getMessageLayer());
                for (Map.Entry property : entry.getValue().getProperties().entrySet()) {
                    provider.addProperty((String)property.getKey(), (String)property.getValue());
                }
                providers.addProvider(provider);
            }
            PersistentProviderRegistrations.writeProviders(providers, CONFIG_FILE);
        }
    }

    private static class RegistrationContextImpl
    implements AuthConfigFactory.RegistrationContext {
        private final String messageLayer;
        private final String appContext;
        private final String description;
        private final boolean persistent;
        private final AuthConfigProvider provider;
        private final Map<String, String> properties;
        private final List<RegistrationListener> listeners = new CopyOnWriteArrayList<RegistrationListener>();

        private RegistrationContextImpl(String messageLayer, String appContext, String description, boolean persistent, AuthConfigProvider provider, Map<String, String> properties) {
            this.messageLayer = messageLayer;
            this.appContext = appContext;
            this.description = description;
            this.persistent = persistent;
            this.provider = provider;
            HashMap<String, String> propertiesCopy = new HashMap<String, String>();
            if (properties != null) {
                propertiesCopy.putAll(properties);
            }
            this.properties = Collections.unmodifiableMap(propertiesCopy);
        }

        @Override
        public String getMessageLayer() {
            return this.messageLayer;
        }

        @Override
        public String getAppContext() {
            return this.appContext;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isPersistent() {
            return this.persistent;
        }

        private AuthConfigProvider getProvider() {
            return this.provider;
        }

        private void addListener(RegistrationListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        private Map<String, String> getProperties() {
            return this.properties;
        }

        private boolean removeListener(RegistrationListener listener) {
            boolean result = false;
            Iterator<RegistrationListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(listener)) continue;
                iter.remove();
            }
            return result;
        }
    }
}

