/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.contrib.javanica.aop.aspectj.HystrixCommandAspect;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsPoller;
import com.netflix.hystrix.contrib.metrics.eventstream.HystrixMetricsStreamServlet;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.actuator.NamedFeature;
import org.springframework.cloud.netflix.hystrix.HystrixMetricsProperties;
import org.springframework.cloud.netflix.hystrix.HystrixStreamEndpoint;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HystrixCircuitBreakerConfiguration {
    @Bean
    public HystrixCommandAspect hystrixCommandAspect() {
        return new HystrixCommandAspect();
    }

    @Bean
    public HystrixShutdownHook hystrixShutdownHook() {
        return new HystrixShutdownHook();
    }

    @Bean
    public HasFeatures hystrixFeature() {
        return HasFeatures.namedFeatures((NamedFeature[])new NamedFeature[]{new NamedFeature("Hystrix", HystrixCommandAspect.class)});
    }

    private class HystrixShutdownHook
    implements DisposableBean {
        private HystrixShutdownHook() {
        }

        public void destroy() throws Exception {
            Hystrix.reset();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"hystrix.metrics.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HystrixMetricsPoller.class, GaugeService.class})
    @EnableConfigurationProperties(value={HystrixMetricsProperties.class})
    protected static class HystrixMetricsPollerConfiguration
    implements SmartLifecycle {
        private static Log logger = LogFactory.getLog(HystrixMetricsPollerConfiguration.class);
        @Autowired(required=false)
        private GaugeService gauges;
        @Autowired
        private HystrixMetricsProperties metricsProperties;
        private ObjectMapper mapper = new ObjectMapper();
        private HystrixMetricsPoller poller;
        private Set<String> reserved = new HashSet<String>(Arrays.asList("group", "name", "type", "currentTime"));

        protected HystrixMetricsPollerConfiguration() {
        }

        public void start() {
            if (this.gauges == null) {
                return;
            }
            HystrixMetricsPoller.MetricsAsJsonPollerListener listener = new HystrixMetricsPoller.MetricsAsJsonPollerListener(){

                public void handleJsonMetric(String json) {
                    try {
                        Map map = (Map)HystrixMetricsPollerConfiguration.this.mapper.readValue(json, Map.class);
                        if (map != null && map.containsKey("type")) {
                            HystrixMetricsPollerConfiguration.this.addMetrics(map, "hystrix.");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            this.poller = new HystrixMetricsPoller(listener, this.metricsProperties.getPollingIntervalMs().intValue());
            this.poller.start();
            logger.info((Object)"Starting poller");
        }

        private void addMetrics(Map<String, Object> map, String root) {
            StringBuilder prefixBuilder = new StringBuilder(root);
            if (map.containsKey("type")) {
                prefixBuilder.append((String)map.get("type"));
                if (map.containsKey("group")) {
                    prefixBuilder.append(".").append(map.get("group"));
                }
                prefixBuilder.append(".").append(map.get("name"));
            }
            String prefix = prefixBuilder.toString();
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (this.reserved.contains(key)) continue;
                if (value instanceof Number) {
                    String name = prefix + "." + key;
                    this.gauges.submit(name, ((Number)value).doubleValue());
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map sub = (Map)value;
                this.addMetrics(sub, prefix);
            }
        }

        public void stop() {
            if (this.poller != null) {
                this.poller.shutdown();
            }
        }

        public boolean isRunning() {
            return this.poller != null ? this.poller.isRunning() : false;
        }

        public int getPhase() {
            return Integer.MAX_VALUE;
        }

        public boolean isAutoStartup() {
            return true;
        }

        public void stop(Runnable callback) {
            if (this.poller != null) {
                this.poller.shutdown();
            }
            callback.run();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"hystrix.stream.endpoint.enabled"}, matchIfMissing=true)
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={Endpoint.class, HystrixMetricsStreamServlet.class})
    protected static class HystrixWebConfiguration {
        protected HystrixWebConfiguration() {
        }

        @Bean
        public HystrixStreamEndpoint hystrixStreamEndpoint() {
            return new HystrixStreamEndpoint();
        }

        @Bean
        public HasFeatures hystrixFeature() {
            return HasFeatures.namedFeature((String)"Hystrix Stream Servlet", HystrixStreamEndpoint.class);
        }
    }
}

