/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.discovery;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.filters.discovery.ServiceRouteMapper;
import org.springframework.cloud.netflix.zuul.filters.discovery.SimpleServiceRouteMapper;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class DiscoveryClientRouteLocator
extends SimpleRouteLocator
implements RefreshableRouteLocator {
    private static final Log log = LogFactory.getLog(DiscoveryClientRouteLocator.class);
    public static final String DEFAULT_ROUTE = "/**";
    private DiscoveryClient discovery;
    private ZuulProperties properties;
    private ServiceRouteMapper serviceRouteMapper;

    public DiscoveryClientRouteLocator(String servletPath, DiscoveryClient discovery, ZuulProperties properties) {
        super(servletPath, properties);
        ServiceInstance instance;
        if (properties.isIgnoreLocalService() && (instance = discovery.getLocalServiceInstance()) != null) {
            String localServiceId = instance.getServiceId();
            if (!properties.getIgnoredServices().contains(localServiceId)) {
                properties.getIgnoredServices().add(localServiceId);
            }
        }
        this.serviceRouteMapper = new SimpleServiceRouteMapper();
        this.discovery = discovery;
        this.properties = properties;
    }

    public DiscoveryClientRouteLocator(String servletPath, DiscoveryClient discovery, ZuulProperties properties, ServiceRouteMapper serviceRouteMapper) {
        this(servletPath, discovery, properties);
        this.serviceRouteMapper = serviceRouteMapper;
    }

    public void addRoute(String path, String location) {
        this.properties.getRoutes().put(path, new ZuulProperties.ZuulRoute(path, location));
        this.refresh();
    }

    public void addRoute(ZuulProperties.ZuulRoute route) {
        this.properties.getRoutes().put(route.getPath(), route);
        this.refresh();
    }

    protected LinkedHashMap<String, ZuulProperties.ZuulRoute> locateRoutes() {
        LinkedHashMap<String, ZuulProperties.ZuulRoute> routesMap = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        routesMap.putAll(super.locateRoutes());
        if (this.discovery != null) {
            LinkedHashMap<String, ZuulProperties.ZuulRoute> staticServices = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
            for (ZuulProperties.ZuulRoute zuulRoute : routesMap.values()) {
                Object serviceId = zuulRoute.getServiceId();
                if (serviceId == null) {
                    serviceId = zuulRoute.getId();
                }
                if (serviceId == null) continue;
                staticServices.put((String)serviceId, zuulRoute);
            }
            List services = this.discovery.getServices();
            String[] stringArray = this.properties.getIgnoredServices().toArray(new String[0]);
            for (String serviceId : services) {
                ZuulProperties.ZuulRoute staticRoute;
                String key = "/" + this.mapRouteToService(serviceId) + DEFAULT_ROUTE;
                if (staticServices.containsKey(serviceId) && ((ZuulProperties.ZuulRoute)staticServices.get(serviceId)).getUrl() == null && !StringUtils.hasText((String)(staticRoute = (ZuulProperties.ZuulRoute)staticServices.get(serviceId)).getLocation())) {
                    staticRoute.setLocation(serviceId);
                }
                if (PatternMatchUtils.simpleMatch((String[])stringArray, (String)serviceId) || routesMap.containsKey(key)) continue;
                routesMap.put(key, new ZuulProperties.ZuulRoute(key, serviceId));
            }
        }
        if (routesMap.get(DEFAULT_ROUTE) != null) {
            ZuulProperties.ZuulRoute defaultRoute = (ZuulProperties.ZuulRoute)routesMap.get(DEFAULT_ROUTE);
            routesMap.remove(DEFAULT_ROUTE);
            routesMap.put(DEFAULT_ROUTE, defaultRoute);
        }
        LinkedHashMap<String, ZuulProperties.ZuulRoute> values = new LinkedHashMap<String, ZuulProperties.ZuulRoute>();
        for (Map.Entry entry : routesMap.entrySet()) {
            String path = (String)entry.getKey();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (StringUtils.hasText((String)this.properties.getPrefix()) && !(path = this.properties.getPrefix() + path).startsWith("/")) {
                path = "/" + path;
            }
            values.put(path, (ZuulProperties.ZuulRoute)entry.getValue());
        }
        return values;
    }

    @Override
    public void refresh() {
        this.doRefresh();
    }

    protected String mapRouteToService(String serviceId) {
        return this.serviceRouteMapper.apply(serviceId);
    }

    protected void addConfiguredRoutes(Map<String, ZuulProperties.ZuulRoute> routes) {
        Map<String, ZuulProperties.ZuulRoute> routeEntries = this.properties.getRoutes();
        for (ZuulProperties.ZuulRoute entry : routeEntries.values()) {
            String route = entry.getPath();
            if (routes.containsKey(route)) {
                log.warn((Object)("Overwriting route " + route + ": already defined by " + routes.get(route)));
            }
            routes.put(route, entry);
        }
    }
}

