/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.post;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ReflectionUtils;

public class SendErrorFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(SendErrorFilter.class);
    protected static final String SEND_ERROR_FILTER_RAN = "sendErrorFilter.ran";
    @Value(value="${error.path:/error}")
    private String errorPath;

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.containsKey((Object)"error.status_code") && !ctx.getBoolean(SEND_ERROR_FILTER_RAN, false);
    }

    public Object run() {
        try {
            RequestDispatcher dispatcher;
            RequestContext ctx = RequestContext.getCurrentContext();
            HttpServletRequest request = ctx.getRequest();
            int statusCode = (Integer)ctx.get((Object)"error.status_code");
            request.setAttribute("javax.servlet.error.status_code", (Object)statusCode);
            if (ctx.containsKey((Object)"error.exception")) {
                Object e = ctx.get((Object)"error.exception");
                log.warn((Object)"Error during filtering", (Throwable)Throwable.class.cast(e));
                request.setAttribute("javax.servlet.error.exception", e);
            }
            if (ctx.containsKey((Object)"error.message")) {
                String message = (String)ctx.get((Object)"error.message");
                request.setAttribute("javax.servlet.error.message", (Object)message);
            }
            if ((dispatcher = request.getRequestDispatcher(this.errorPath)) != null) {
                ctx.set(SEND_ERROR_FILTER_RAN, (Object)true);
                if (!ctx.getResponse().isCommitted()) {
                    dispatcher.forward((ServletRequest)request, (ServletResponse)ctx.getResponse());
                }
            }
        }
        catch (Exception ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
        return null;
    }

    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }
}

