/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import com.netflix.loadbalancer.ZoneSnapshot;
import com.netflix.loadbalancer.ZoneStats;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import com.netflix.servo.monitor.Monitors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class LoadBalancerStats {
    private static final String PREFIX = "LBStats_";
    String name;
    volatile Map<String, ZoneStats> zoneStatsMap = new ConcurrentHashMap<String, ZoneStats>();
    volatile Map<String, List<? extends Server>> upServerListZoneMap = new ConcurrentHashMap<String, List<? extends Server>>();
    private volatile DynamicIntProperty connectionFailureThreshold;
    private volatile DynamicIntProperty circuitTrippedTimeoutFactor;
    private volatile DynamicIntProperty maxCircuitTrippedTimeout;
    private static final DynamicIntProperty SERVERSTATS_EXPIRE_MINUTES = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer.serverStats.expire.minutes", 30);
    private final LoadingCache<Server, ServerStats> serverStatsCache = CacheBuilder.newBuilder().expireAfterAccess((long)SERVERSTATS_EXPIRE_MINUTES.get(), TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<Server, ServerStats>(){

        public void onRemoval(RemovalNotification<Server, ServerStats> notification) {
            ((ServerStats)notification.getValue()).close();
        }
    }).build((CacheLoader)new CacheLoader<Server, ServerStats>(){

        public ServerStats load(Server server) {
            return LoadBalancerStats.this.createServerStats(server);
        }
    });
    private static Comparator<ServerStats> serverStatsComparator = new Comparator<ServerStats>(){

        @Override
        public int compare(ServerStats o1, ServerStats o2) {
            String zone1 = "";
            String zone2 = "";
            if (o1.server != null && o1.server.getZone() != null) {
                zone1 = o1.server.getZone();
            }
            if (o2.server != null && o2.server.getZone() != null) {
                zone2 = o2.server.getZone();
            }
            return zone1.compareTo(zone2);
        }
    };

    private ServerStats createServerStats(Server server) {
        ServerStats ss = new ServerStats(this);
        ss.setBufferSize(1000);
        ss.setPublishInterval(1000);
        ss.initialize(server);
        return ss;
    }

    private LoadBalancerStats() {
        this.zoneStatsMap = new ConcurrentHashMap<String, ZoneStats>();
        this.upServerListZoneMap = new ConcurrentHashMap<String, List<? extends Server>>();
    }

    public LoadBalancerStats(String name) {
        this();
        this.name = name;
        Monitors.registerObject((String)name, (Object)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    DynamicIntProperty getConnectionFailureCountThreshold() {
        if (this.connectionFailureThreshold == null) {
            this.connectionFailureThreshold = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer." + this.name + ".connectionFailureCountThreshold", 3);
        }
        return this.connectionFailureThreshold;
    }

    DynamicIntProperty getCircuitTrippedTimeoutFactor() {
        if (this.circuitTrippedTimeoutFactor == null) {
            this.circuitTrippedTimeoutFactor = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer." + this.name + ".circuitTripTimeoutFactorSeconds", 10);
        }
        return this.circuitTrippedTimeoutFactor;
    }

    DynamicIntProperty getCircuitTripMaxTimeoutSeconds() {
        if (this.maxCircuitTrippedTimeout == null) {
            this.maxCircuitTrippedTimeout = DynamicPropertyFactory.getInstance().getIntProperty("niws.loadbalancer." + this.name + ".circuitTripMaxTimeoutSeconds", 30);
        }
        return this.maxCircuitTrippedTimeout;
    }

    public void updateServerList(List<Server> servers) {
        for (Server s : servers) {
            this.addServer(s);
        }
    }

    public void addServer(Server server) {
        try {
            this.serverStatsCache.get((Object)server);
        }
        catch (ExecutionException e) {
            ServerStats stats = this.createServerStats(server);
            this.serverStatsCache.asMap().putIfAbsent(server, stats);
        }
    }

    public void noteResponseTime(Server server, double msecs) {
        ServerStats ss = this.getServerStats(server);
        ss.noteResponseTime(msecs);
    }

    private ServerStats getServerStats(Server server) {
        try {
            return (ServerStats)this.serverStatsCache.get((Object)server);
        }
        catch (ExecutionException e) {
            ServerStats stats = this.createServerStats(server);
            this.serverStatsCache.asMap().putIfAbsent(server, stats);
            return (ServerStats)this.serverStatsCache.asMap().get(server);
        }
    }

    public void incrementActiveRequestsCount(Server server) {
        ServerStats ss = this.getServerStats(server);
        ss.incrementActiveRequestsCount();
    }

    public void decrementActiveRequestsCount(Server server) {
        ServerStats ss = this.getServerStats(server);
        ss.decrementActiveRequestsCount();
    }

    private ZoneStats getZoneStats(String zone) {
        ZoneStats zs = this.zoneStatsMap.get(zone = zone.toLowerCase());
        if (zs == null) {
            this.zoneStatsMap.put(zone, new ZoneStats(this.getName(), zone, this));
            zs = this.zoneStatsMap.get(zone);
        }
        return zs;
    }

    public boolean isCircuitBreakerTripped(Server server) {
        ServerStats ss = this.getServerStats(server);
        return ss.isCircuitBreakerTripped();
    }

    public void incrementSuccessiveConnectionFailureCount(Server server) {
        ServerStats ss = this.getServerStats(server);
        ss.incrementSuccessiveConnectionFailureCount();
    }

    public void clearSuccessiveConnectionFailureCount(Server server) {
        ServerStats ss = this.getServerStats(server);
        ss.clearSuccessiveConnectionFailureCount();
    }

    public void incrementNumRequests(Server server) {
        ServerStats ss = this.getServerStats(server);
        ss.incrementNumRequests();
    }

    public void incrementZoneCounter(Server server) {
        String zone = server.getZone();
        if (zone != null) {
            this.getZoneStats(zone).incrementCounter();
        }
    }

    public void updateZoneServerMapping(Map<String, List<Server>> map) {
        this.upServerListZoneMap = new ConcurrentHashMap<String, List<Server>>(map);
        for (String zone : map.keySet()) {
            this.getZoneStats(zone);
        }
    }

    public int getInstanceCount(String zone) {
        if (zone == null) {
            return 0;
        }
        List<? extends Server> currentList = this.upServerListZoneMap.get(zone = zone.toLowerCase());
        if (currentList == null) {
            return 0;
        }
        return currentList.size();
    }

    public int getActiveRequestsCount(String zone) {
        return this.getZoneSnapshot(zone).getActiveRequestsCount();
    }

    public double getActiveRequestsPerServer(String zone) {
        return this.getZoneSnapshot(zone).getLoadPerServer();
    }

    public ZoneSnapshot getZoneSnapshot(String zone) {
        if (zone == null) {
            return new ZoneSnapshot();
        }
        zone = zone.toLowerCase();
        List<? extends Server> currentList = this.upServerListZoneMap.get(zone);
        return this.getZoneSnapshot(currentList);
    }

    public ZoneSnapshot getZoneSnapshot(List<? extends Server> servers) {
        if (servers == null || servers.size() == 0) {
            return new ZoneSnapshot();
        }
        int instanceCount = servers.size();
        int activeConnectionsCount = 0;
        int activeConnectionsCountOnAvailableServer = 0;
        int circuitBreakerTrippedCount = 0;
        double loadPerServer = 0.0;
        long currentTime = System.currentTimeMillis();
        for (Server server : servers) {
            ServerStats stat = this.getSingleServerStat(server);
            if (stat.isCircuitBreakerTripped(currentTime)) {
                ++circuitBreakerTrippedCount;
            } else {
                activeConnectionsCountOnAvailableServer += stat.getActiveRequestsCount(currentTime);
            }
            activeConnectionsCount += stat.getActiveRequestsCount(currentTime);
        }
        if (circuitBreakerTrippedCount == instanceCount) {
            if (instanceCount > 0) {
                loadPerServer = -1.0;
            }
        } else {
            loadPerServer = (double)activeConnectionsCountOnAvailableServer / (double)(instanceCount - circuitBreakerTrippedCount);
        }
        return new ZoneSnapshot(instanceCount, circuitBreakerTrippedCount, activeConnectionsCount, loadPerServer);
    }

    public int getCircuitBreakerTrippedCount(String zone) {
        return this.getZoneSnapshot(zone).getCircuitTrippedCount();
    }

    @Monitor(name="LBStats_CircuitBreakerTrippedCount", type=DataSourceType.GAUGE)
    public int getCircuitBreakerTrippedCount() {
        int count = 0;
        for (String zone : this.upServerListZoneMap.keySet()) {
            count += this.getCircuitBreakerTrippedCount(zone);
        }
        return count;
    }

    public long getMeasuredZoneHits(String zone) {
        if (zone == null) {
            return 0L;
        }
        zone = zone.toLowerCase();
        long count = 0L;
        List<? extends Server> currentList = this.upServerListZoneMap.get(zone);
        if (currentList == null) {
            return 0L;
        }
        for (Server server : currentList) {
            ServerStats stat = this.getSingleServerStat(server);
            count += stat.getMeasuredRequestsCount();
        }
        return count;
    }

    public int getCongestionRatePercentage(String zone) {
        if (zone == null) {
            return 0;
        }
        List<? extends Server> currentList = this.upServerListZoneMap.get(zone = zone.toLowerCase());
        if (currentList == null || currentList.size() == 0) {
            return 0;
        }
        int serverCount = currentList.size();
        int activeConnectionsCount = 0;
        int circuitBreakerTrippedCount = 0;
        for (Server server : currentList) {
            ServerStats stat = this.getSingleServerStat(server);
            activeConnectionsCount += stat.getActiveRequestsCount();
            if (!stat.isCircuitBreakerTripped()) continue;
            ++circuitBreakerTrippedCount;
        }
        return (int)((long)(activeConnectionsCount + circuitBreakerTrippedCount) * 100L / (long)serverCount);
    }

    @Monitor(name="LBStats_AvailableZones", type=DataSourceType.INFORMATIONAL)
    public Set<String> getAvailableZones() {
        return this.upServerListZoneMap.keySet();
    }

    public ServerStats getSingleServerStat(Server server) {
        return this.getServerStats(server);
    }

    public Map<Server, ServerStats> getServerStats() {
        return this.serverStatsCache.asMap();
    }

    public Map<String, ZoneStats> getZoneStats() {
        return this.zoneStatsMap;
    }

    public String toString() {
        return "Zone stats: " + this.zoneStatsMap.toString() + "," + "Server stats: " + LoadBalancerStats.getSortedServerStats(this.getServerStats().values()).toString();
    }

    private static Collection<ServerStats> getSortedServerStats(Collection<ServerStats> stats) {
        ArrayList<ServerStats> list = new ArrayList<ServerStats>(stats);
        Collections.sort(list, serverStatsComparator);
        return list;
    }
}

