/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.DefaultConfigurationProvider;
import com.netflix.governator.configuration.Property;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectConfigurationProvider
extends DefaultConfigurationProvider {
    private final Logger logger;
    private final ObjectMapper mapper;

    protected AbstractObjectConfigurationProvider() {
        this(null);
    }

    protected AbstractObjectConfigurationProvider(ObjectMapper mapper) {
        this.mapper = mapper == null ? new ObjectMapper() : mapper;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public <T> Property<T> getObjectProperty(final ConfigurationKey key, final T defaultValue, final Class<T> objectType) {
        return new Property<T>(){

            @Override
            public T get() {
                String serialized = (String)AbstractObjectConfigurationProvider.this.getStringSupplier(key, null).get();
                if (serialized == null || serialized.length() == 0) {
                    return defaultValue;
                }
                try {
                    return AbstractObjectConfigurationProvider.this.mapper.readValue(serialized, objectType);
                }
                catch (IOException e) {
                    AbstractObjectConfigurationProvider.this.logger.warn("Could not deserialize configuration with key " + key.getRawKey() + " to type " + objectType, (Throwable)e);
                    return defaultValue;
                }
            }
        };
    }
}

